% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onca.R
\name{onca}
\alias{onca}
\title{Oxford Name Compression Algorithm}
\usage{
onca(word, maxCodeLen = 4, clean = TRUE, modified = FALSE,
  refined = FALSE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}

\item{modified}{if \code{TRUE}, use the modified \code{nysiis} function}

\item{refined}{if \code{TRUE}, use the \code{refinedSoundex} function}
}
\value{
the ONCA encoded character vector
}
\description{
The Oxford Name Compression Algorithm name coding procedure
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is the limit on how long the returned name code
should be.  The default is 4.

The \code{onca} algorithm is only defined for inputs over the
standard English alphabet, \emph{i.e.}, "A-Z.". Non-alphabetical
characters are removed from the string in a locale-dependent fashion.
This strips spaces, hyphens, and numbers.  Other letters, such as
"Ü," may be permissible in the current locale but are unknown to
\code{onca}.  For inputs outside of its known range, the output is
undefined and \code{NA} is returned and a \code{warning} this thrown.
If \code{clean} is \code{FALSE}, \code{onca} attempts to process the
strings.  The default is \code{TRUE}.
}
\examples{
onca("William")
onca(c("Peter", "Peady"))
onca("Stevenson", maxCodeLen = 8)

}
\references{
Gill, Leicester. "OX-LINK: the Oxford medical record linkage system." (1997).
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{cologne}}, \code{\link{lein}},
  \code{\link{metaphone}}, \code{\link{mra_encode}},
  \code{\link{nysiis}}, \code{\link{phonex}},
  \code{\link{phonics}}, \code{\link{rogerroot}},
  \code{\link{soundex}}, \code{\link{statcan}}
}
\concept{phonics}
