% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\docType{data}
\name{preCalcWeights}
\alias{preCalcWeights}
\title{Pre-calculated weights for calculating phenotype risk scores}
\format{
A data.table with the following columns:
\itemize{
\item \code{phecode}: Character vector of phecodes
\item \code{prev}: Numeric vector of prevalences, i.e., fraction of subjects in the SD
that have at least one occurrence of the given phecode
\item \code{w}: Numeric vector of weights, calculated as \code{-log10(prev)}
}
}
\usage{
preCalcWeights
}
\description{
The weights are based on EHR data from the Vanderbilt University Medical
Center Synthetic Derivative (SD) and ICD-phecode map version 1.2 and are
calculated using the "prevalence" method.
}
\seealso{
\code{\link[=getWeights]{getWeights()}}
}
\keyword{datasets}
