% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.phenologyout.R
\name{summary.phenologyout}
\alias{summary.phenologyout}
\title{Print the summary information from a ouput object.}
\usage{
\method{summary}{phenologyout}(object, ...)
}
\arguments{
\item{object}{An output generated by plot.phenology() ou summary.phenology()}

\item{...}{Not used}
}
\value{
None
}
\description{
The function summary.phenologyout displays the output from a plot.
}
\details{
summary.phenologyout prints the information from a result object.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
output <- plot(result_Gratiot)
# Show the output
summary(output)
}
}
\author{
Marc Girondot
}
