% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wHANTS.R
\name{wHANTS}
\alias{wHANTS}
\title{Weighted HANTS SMOOTH}
\usage{
wHANTS(y, t, w, nf = 3, ylu, periodlen = 365, nptperyear,
  wFUN = wTSM, iters = 2, wmin = 0.1, ...)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified, 
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{nf}{number of frequencies to be considered above the zero frequency}

\item{ylu}{[low, high] of time-series y (curve fitting values are constrained
in the range of \code{ylu}.}

\item{periodlen}{length of the base period, measured in virtual samples
(days, dekads, months, etc.). nptperyear in timesat.}

\item{nptperyear}{Integer, number of images per year.}

\item{wFUN}{weights updating function, can be one of 'wTSM', 'wChen' and
'wBisquare'.}

\item{iters}{How many times curve fitting is implemented.}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{...}{Additional parameters are passed to \code{wFUN}.}
}
\value{
\itemize{
   \item \code{ws} weights of every iteration
   \item \code{zs} curve fittings of every iteration
}
}
\description{
Weighted HANTS smoother
}
\examples{
library(phenofit)
data("MOD13A1")
dt <- tidy_MOD13.gee(MOD13A1$dt)
d <- dt[site == "AT-Neu", ]

l <- check_input(d$t, d$y, d$w, nptperyear=23)
r_wHANTS <- wHANTS(l$y, l$t, l$w, ylu = l$ylu, nptperyear = 23, iters = 2)
}
\author{
Wout Verhoef, NLR, Remote Sensing Dept. June 1998
Mohammad Abouali (2011), Converted to MATLAB
Dongdong Kong (2018), introduced to R and modified into weighted model.
}
