% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_modelsearch}
\alias{run_modelsearch}
\title{run_modelsearch}
\usage{
run_modelsearch(
  search_space,
  algorithm,
  iiv_strategy = "absorption_delay",
  rank_type = "bic",
  cutoff = NULL,
  results = NULL,
  model = NULL,
  ...
)
}
\arguments{
\item{search_space}{(str) Search space to test}

\item{algorithm}{(str) Algorithm to use (e.g. exhaustive)}

\item{iiv_strategy}{(str) If/how IIV should be added to candidate models. Possible strategies are 'no_add',
'add_diagonal', 'fullblock', or 'absorption_delay'. Default is 'absorption_delay'}

\item{rank_type}{(str) Which ranking type should be used (OFV, AIC, BIC). Default is BIC}

\item{cutoff}{(numeric (optional)) Cutoff for which value of the ranking function that is considered significant. Default
is NULL (all models will be ranked)}

\item{results}{(ModelfitResults (optional)) Results for model}

\item{model}{(Model (optional)) Pharmpy mode}

\item{...}{Arguments to pass to tool}
}
\value{
(ModelSearchResults) Modelsearch tool result object
}
\description{
Run Modelsearch tool. For more details, see :ref:\code{modelsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
run_modelsearch('ABSORPTION(ZO);PERIPHERALS(1)', 'exhaustive', results=results, model=model)
}

}
