% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{has_covariate_effect}
\alias{has_covariate_effect}
\title{has_covariate_effect}
\usage{
has_covariate_effect(model, parameter, covariate)
}
\arguments{
\item{model}{(Model) Pharmpy model to check for covariate effect.}

\item{parameter}{(str) Name of parameter.}

\item{covariate}{(str) Name of covariate.}
}
\value{
(logical) Whether input model has a covariate effect of the input covariate on the input parameter.
}
\description{
Tests if an instance of :class:\code{pharmpy.model} has a given covariate
effect.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
has_covariate_effect(model, "CL", "APGR")
}

}
