% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_covariate_baselines}
\alias{get_covariate_baselines}
\title{get_covariate_baselines}
\usage{
get_covariate_baselines(model)
}
\arguments{
\item{model}{(Model) Pharmpy model}
}
\value{
(data.frame) covariate baselines
}
\description{
Return a dataframe with baselines of all covariates for each id.

Baseline is taken to be the first row even if that has a missing value.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model$datainfo[["WGT", "APGR"]].types <- "covariate"
get_covariate_baselines(model)
}
}
\seealso{
get_baselines : baselines for all data columns
}
