% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_doc.R
\name{rtf_doc}
\alias{rtf_doc}
\title{Create a \code{rtf_doc} object}
\usage{
rtf_doc(table, titles = list(), footnotes = list(), header_rows = 1)
}
\arguments{
\item{table}{A table of a supported class.}

\item{titles}{A list of \code{hf_line} objects containing table titles and
associated formatting.}

\item{footnotes}{A list of \code{hf_line} objects containing table footnotes
and associated formatting.}

\item{header_rows}{An integer determining how many rows of the table are
column headers. Only used for huxtable tables.}
}
\value{
A list with a table, titles, and footnotes component. Class of
  "rtf_doc" with the properties describled below.
}
\description{
This constructs the main object that will be used for an RTF document. The
object is composed of a table, titles(s), and footnote(s).

A table contained in the \code{rtf_doc} object should be a supported class.
The huxtable package is the most supported, however our intention is to
support other packages capable of writing RTF tables as well. Currently, it
is planned to support the \code{gt} package, but the \code{gt} package's RTF
methods are not functional.

The titles and footnotes are composed of \code{hf_line} objects.

See the \href{https://atorus-research.github.io/pharmaRTF.html}{vignette}
for a more complete view of intended usage.
}
\section{\code{rtf_doc} Properties}{

Document level properties set the defaults and will be used where they are
not overridden by \code{hf_line} or table properties.
\itemize{
\item{font - A string representing the font to display when it is not
  specified by the table or \code{hf_line}. Defaults to Courier New.}
\item{font_size - A numeric value representing the size of the font in
  points. Defaults to 12.}
\item{margins - Inches of margins in the document as a named vector. Names
  are \code{top}, \code{bottom}, \code{left}, and \code{right}. Defaults to 1
  for all.}
\item{orientation - Orientation of the document. Defaults to 'landscape'. When 'portrait',
  the height and width are switched while writing the document to effectively rotate the document
  90 degrees. For example, if width is 11" and height is 8.5", while writing the document will have a
  height of 11" and a width of 8.5". Additionally, when 'landscape', a keyword is written
  to the RTF to indicate that the document is landscape. .}
\item{header_height - Height of the header where the titles and column
  headers are displayed. Defaults to .5 inches.}
\item{footer_height - Height of the footer where the footnotes are displayed.
  Defaults to .5 inches.}
\item{pagesize - Size of the page in inches. Defaults to 8.5(height) by
  11(width). These defaults align with the default orientation of 'landscape'. When the orientation
  is switched to 'portrait', the height and width will switch while the RTF document is being generated,
  but the document attributes themselves will not change.}
\item{header_rows - Huxtable table only. Number of rows that are defined as
  the header that will be repeated across pages. Defaults to 1}
\item{ignore_cell_padding - Huxtable table only. Flag to ignore cell padding padding
  that is added during RTF encoding. Minimizes the amount of space between
  rows. Defaults to FALSE.}
\item{column_header_buffer} - This attribute adds rows to the top or bottom of the table
  column headers to pad it from the titles above or the table below.
  Defaults to 0 and 0.
}
}

\examples{
# Adding lines during rtf_doc construction
ht <- huxtable::huxtable(
 column1 = 1:5,
 column2 = letters[1:5]
)
# Set table properties
library(magrittr) #load in a pipe
ht \%>\%
  huxtable::set_bold(1, 1:ncol(ht), TRUE) \%>\%
  huxtable::set_escape_contents(TRUE) \%>\%
  huxtable::set_col_width(c(0.25, 0.75))

rtf <- rtf_doc(ht, titles = list(hf_line("My Header")))
# Set document properties
rtf <- rtf \%>\%
  set_font_size(15) \%>\%
  set_ignore_cell_padding(TRUE)

names(rtf)

write_rtf(rtf, file = tempfile())

}
\seealso{
\code{\link{hf_line}}
}
