/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.outputdevices;

import java.io.IOException;
import net.sf.eps2pgf.ps.GraphicsState;
import net.sf.eps2pgf.ps.Image;
import net.sf.eps2pgf.ps.Path;
import net.sf.eps2pgf.ps.errors.PSErrorNoCurrentPoint;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;

public class CacheDevice
implements OutputDevice {
    private double specifiedWx = 0.0;
    private double specifiedWy = 0.0;
    private double specifiedLlx = 0.0;
    private double specifiedLly = 0.0;
    private double specifiedUrx = 0.0;
    private double specifiedUry = 0.0;
    private double[] pathBbox = null;

    public CacheDevice(double d, double d2, double d3, double d4, double d5, double d6) {
        this.specifiedWx = d;
        this.specifiedWy = d2;
        this.specifiedLlx = d3;
        this.specifiedLly = d4;
        this.specifiedUrx = d5;
        this.specifiedUry = d6;
    }

    public void clip(Path path) {
    }

    public CacheDevice clone() {
        CacheDevice cacheDevice;
        try {
            cacheDevice = (CacheDevice)super.clone();
            if (this.pathBbox != null) {
                cacheDevice.pathBbox = (double[])this.pathBbox.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cacheDevice = null;
        }
        return cacheDevice;
    }

    public PSObjectMatrix defaultCTM() {
        return new PSObjectMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void init() {
    }

    public double[] eps2pgfGetMetrics() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.pathBbox != null) {
            d = Math.max(this.specifiedLlx, this.pathBbox[0]);
            d2 = Math.max(this.specifiedLly, this.pathBbox[1]);
            d3 = Math.min(this.specifiedUrx, this.pathBbox[2]);
            d4 = Math.min(this.specifiedUry, this.pathBbox[3]);
        }
        double[] dArray = new double[]{this.specifiedWx, this.specifiedWy, d, d2, d3, d4};
        return dArray;
    }

    public void finish() {
    }

    public void fill(GraphicsState graphicsState) {
        try {
            this.mergeBbox(graphicsState.getPath().boundingBox());
        }
        catch (PSErrorNoCurrentPoint pSErrorNoCurrentPoint) {
            // empty catch block
        }
    }

    public void eoclip(GraphicsState graphicsState) {
    }

    public void eofill(GraphicsState graphicsState) {
        try {
            this.mergeBbox(graphicsState.getPath().boundingBox());
        }
        catch (PSErrorNoCurrentPoint pSErrorNoCurrentPoint) {
            // empty catch block
        }
    }

    void mergeBbox(double[] dArray) {
        if (this.pathBbox == null) {
            this.pathBbox = (double[])dArray.clone();
        } else {
            this.pathBbox[0] = Math.min(this.pathBbox[0], dArray[0]);
            this.pathBbox[1] = Math.min(this.pathBbox[1], dArray[1]);
            this.pathBbox[2] = Math.max(this.pathBbox[2], dArray[2]);
            this.pathBbox[3] = Math.max(this.pathBbox[3], dArray[3]);
        }
    }

    public void shfill(PSObjectDict pSObjectDict, GraphicsState graphicsState) {
        try {
            this.mergeBbox(graphicsState.getPath().boundingBox());
        }
        catch (PSErrorNoCurrentPoint pSErrorNoCurrentPoint) {
            // empty catch block
        }
    }

    public void stroke(GraphicsState graphicsState) {
        try {
            this.mergeBbox(graphicsState.getPath().boundingBox());
        }
        catch (PSErrorNoCurrentPoint pSErrorNoCurrentPoint) {
            // empty catch block
        }
    }

    public void startScope() {
    }

    public void endScope() {
    }

    public void show(String string, double[] dArray, double d, double d2, String string2, GraphicsState graphicsState) {
    }

    public void drawDot(double d, double d2) {
    }

    public void drawRect(double[] dArray, double[] dArray2) {
    }

    public void image(Image image) throws IOException {
        double[] dArray = new double[4];
        double[][] dArray2 = image.getDeviceBbox();
        dArray[0] = Math.min(dArray2[0][0], Math.min(dArray2[1][0], Math.min(dArray2[2][0], dArray2[3][0])));
        dArray[1] = Math.min(dArray2[0][1], Math.min(dArray2[1][1], Math.min(dArray2[2][1], dArray2[3][1])));
        dArray[2] = Math.max(dArray2[0][0], Math.max(dArray2[1][0], Math.max(dArray2[2][0], dArray2[3][0])));
        dArray[3] = Math.max(dArray2[0][1], Math.max(dArray2[1][1], Math.max(dArray2[2][1], dArray2[3][1])));
        this.mergeBbox(dArray);
    }
}

