% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{range}
\alias{range}
\title{Python-style range function}
\usage{
range(a, b, ...)
}
\arguments{
\item{a}{minimum, integer}

\item{b}{supremum, integer}

\item{...}{other params passed to \code{base::seq()}}
}
\description{
Wrapper around \code{base::seq} that replaces the maximal end value with the supremum
and returns an empty vector if b <= a, in the style of Python's \code{range()}.
Note that \code{peruse::range} views end as a supremum, not a maximum, thus range(a,b)
is equivalent to the set \code{[}a,b) when a < b or \code{{}} when b >= a.
}
\examples{
range(1,5)
range(9,10)
}
