% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_homogeneity.R
\name{check_homogeneity}
\alias{check_homogeneity}
\title{Check model for homogeneity of variances}
\usage{
check_homogeneity(x, method = c("bartlett", "fligner", "auto"), ...)
}
\arguments{
\item{x}{A linear model or an ANOVA object.}

\item{method}{Name of the method (underlying test) that should be performend
to check the homogeneity of variances. May either be \code{"bartlett"} for
the Bartlett test (assuming normal distributed samples or groups),
\code{"fligner"} for the Fligner-Killeen test (rank-based, non-parametric test),
or \code{"auto"}. In the latter case, Bartlett test is used if the model response
is normal distributed, else Fligner-Killeen test is used.}

\item{...}{Currently not used.}
}
\value{
Invisibly returns the p-value of the test statistics. A p-value
< 0.05 indicates a significant difference in the variance between the groups.
}
\description{
Check model for homogeneity of variances between groups described
by independent variables in a model.
}
\examples{
model <- lm(len ~ supp + dose, data = ToothGrowth)
check_homogeneity(model)

# plot results
result <- check_homogeneity(model)
plot(result)
}
