% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_zeroinflated.R
\name{r2_zeroinflated}
\alias{r2_zeroinflated}
\title{R2 for models with zero-inflation}
\usage{
r2_zeroinflated(model, method = c("default", "correlation"))
}
\arguments{
\item{model}{A model.}

\item{method}{Indicates the method to calculate R2. See 'Details'. May be abbreviated.}
}
\value{
For the default-method, a list with the R2 and adjusted R2 values.
  For \code{method = "correlation"}, a named numeric vector with the
  correlation-based R2 value.
}
\description{
Calculates R2 for models with zero-inflation component, including mixed effects models.
}
\details{
The default-method calculates an R2 value based on the residual
  variance divided by the total variance. For \code{method = "correlation"},
  R2 is a correlation-based measure, which is rather crude. It simply computes
  the squared correlation between the model's actual and predicted reponse.
}
\examples{
library(pscl)
data(bioChemists)
model <- zeroinfl(
  art ~ fem + mar + kid5 + ment | kid5 + phd,
  data = bioChemists
)

r2_zeroinflated(model)

}
