% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals}
\alias{check_residuals}
\alias{check_residuals.default}
\title{Check distribution of simulated quantile residuals}
\usage{
check_residuals(x, ...)

\method{check_residuals}{default}(x, alternative = "two.sided", distribution = "punif", ...)
}
\arguments{
\item{x}{A supported model object or an object returned by
\code{\link[=simulate_residuals]{simulate_residuals()}} or \code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}.}

\item{...}{Passed down to \code{\link[stats:ks.test]{stats::ks.test()}}.}

\item{alternative}{A character string specifying the alternative hypothesis.
Can be one of \code{"two.sided"}, \code{"less"}, or \code{"greater"}. See
\code{\link[stats:ks.test]{stats::ks.test()}} for details.}

\item{distribution}{The distribution to compare the residuals against.
Can be (a) a character value giving a cumulative distribution function
(for example, \code{"punif"} (default) or \code{"pnorm"}), (b) a cumulative distribution
function itself (for example, \code{punif} or \code{pnorm}), or (c) a numeric vector
of values.}
}
\value{
The p-value of the test statistics.
}
\description{
\code{check_residuals()} checks generalized linear (mixed) models for uniformity
of randomized quantile residuals, which can be used to identify typical model
misspecification problems, such as over/underdispersion, zero-inflation, and
residual spatial and temporal autocorrelation.
}
\details{
Simulated quantile residuals are generated by simulating a series of
values from a fitted model for each case, comparing the observed response
values to these simulations, and computing the empirical quantile of the
observed value in the distribution of simulated values. When the model is
correctly-specified, these quantile residuals will follow a \emph{uniform} (flat)
distribution. \code{check_residuals()} tests the distribution of the quantile
residuals against the uniform distribution using a Kolmogorov-Smirnov test.
Essentially, comparing quantile residuals to the uniform distribution tests
whether the observed response values deviate from model expectations
(i.e., simulated values). In this sense, \code{check_residuals()} is similar to
posterior predictive checks with \code{\link[=check_predictions]{check_predictions()}}.

There is a \code{plot()} method to visualize the distribution of quantile residuals
using a Q-Q plot. This plot can be interpreted in the same way as a Q-Q plot
for normality of residuals in linear regression.

If desired, a different theoretical distribution or a vector of numeric
values can be tested against using the \code{distribution} argument.
}
\section{Tests based on simulated residuals}{

For certain models, resp. model from certain families, tests like
\code{\link[=check_zeroinflation]{check_zeroinflation()}} or \code{\link[=check_overdispersion]{check_overdispersion()}} are based on
simulated residuals. These are usually more accurate for such tests than
the traditionally used Pearson residuals. However, when simulating from more
complex models, such as mixed models or models with zero-inflation, there are
several important considerations. \code{simulate_residuals()} relies on
\code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}, and additional arguments specified in \code{...}
are passed further down to that function. The defaults in DHARMa are set on
the most conservative option that works for all models. However, in many
cases, the help advises to use different settings in particular situations
or for particular models. It is recommended to read the 'Details' in
\code{?DHARMa::simulateResiduals} closely to understand the implications of the
simulation process and which arguments should be modified to get the most
accurate results.
}

\examples{
\dontshow{if (require("DHARMa")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dat <- DHARMa::createData(sampleSize = 100, overdispersion = 0.5, family = poisson())
m <- glm(observedResponse ~ Environment1, family = poisson(), data = dat)
res <- simulate_residuals(m)
check_residuals(res)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=simulate_residuals]{simulate_residuals()}}, \code{\link[=check_zeroinflation]{check_zeroinflation()}},
\code{\link[=check_overdispersion]{check_overdispersion()}} and \code{\link[=check_predictions]{check_predictions()}}. See also
\code{\link[see:plot.see_performance_simres]{see::plot.see_performance_simres()}} for options to customize the plot.
}
