% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_properties.R
\name{marker_prop}
\alias{marker_prop}
\alias{emptyMarker}
\alias{emptyMarker.default}
\alias{emptyMarker.marker}
\alias{emptyMarker.ped}
\alias{emptyMarker.list}
\alias{nTyped}
\alias{nTyped.default}
\alias{nTyped.marker}
\alias{nTyped.ped}
\alias{nTyped.list}
\alias{nAlleles}
\alias{nAlleles.default}
\alias{nAlleles.marker}
\alias{nAlleles.ped}
\alias{nAlleles.list}
\alias{isXmarker}
\alias{isXmarker.default}
\alias{isXmarker.marker}
\alias{isXmarker.ped}
\alias{isXmarker.list}
\alias{allowsMutations}
\alias{allowsMutations.default}
\alias{allowsMutations.marker}
\alias{allowsMutations.ped}
\alias{allowsMutations.list}
\title{Marker properties}
\usage{
emptyMarker(x, ...)

\method{emptyMarker}{default}(x, ...)

\method{emptyMarker}{marker}(x, ...)

\method{emptyMarker}{ped}(x, markers = seq_len(nMarkers(x)), ...)

\method{emptyMarker}{list}(x, markers = seq_len(nMarkers(x)), ...)

nTyped(x, ...)

\method{nTyped}{default}(x, ...)

\method{nTyped}{marker}(x, ...)

\method{nTyped}{ped}(x, markers = seq_len(nMarkers(x)), ...)

\method{nTyped}{list}(x, markers = seq_len(nMarkers(x)), ...)

nAlleles(x, ...)

\method{nAlleles}{default}(x, ...)

\method{nAlleles}{marker}(x, ...)

\method{nAlleles}{ped}(x, markers = seq_len(nMarkers(x)), ...)

\method{nAlleles}{list}(x, markers = seq_len(nMarkers(x)), ...)

isXmarker(x, ...)

\method{isXmarker}{default}(x, ...)

\method{isXmarker}{marker}(x, ...)

\method{isXmarker}{ped}(x, markers = seq_len(nMarkers(x)), ...)

\method{isXmarker}{list}(x, markers = seq_len(nMarkers(x)), ...)

allowsMutations(x, ...)

\method{allowsMutations}{default}(x, ...)

\method{allowsMutations}{marker}(x, ...)

\method{allowsMutations}{ped}(x, markers = seq_len(nMarkers(x)), ...)

\method{allowsMutations}{list}(x, markers = seq_len(nMarkers(x)), ...)
}
\arguments{
\item{x}{A single \code{marker} object or a \code{ped} object (or a list of such)}

\item{...}{Not used.}

\item{markers}{A vector of names or indices of markers attached to \code{x}, in
the case that \code{x} is a \code{ped} object or a list of such. By default all
attached markers are selected.}
}
\value{
If \code{x} is a single \code{marker} object, the output is a vector of length 1.

If \code{x} is a \code{ped} object, or a list of such, the output is a vector of the
same length as \code{markers} (which includes all attached markers by default),
reporting the property of each marker.
}
\description{
These functions are used to retrieve various properties of marker objects.
Each function accepts as input either a single \code{marker} object, a \code{ped}
object, or a list of \code{ped} objects.
}
\details{
\code{emptyMarker()} returns TRUE for markers with no genotypes. If the input is a
list of pedigrees, all must be empty for the result to be TRUE.

\code{nTyped()} returns the number of typed individuals for each marker. Note that
if the input is a list of pedigrees, the function returns the sum over all
components.

\code{nAlleles()} returns the number of alleles of each marker.

\code{isXmarker()} returns TRUE for markers whose \code{chrom} attribute is either "X"
or 23.

\code{allowsMutations} returns TRUE for markers whose \code{mutmod} attribute is
non-NULL and differs from the identity matrix.
}
\examples{
cmp1 = nuclearPed(1)
cmp2 = singleton(10)
loc = list(alleles = 1:2)
x = setMarkers(list(cmp1, cmp2), locus = rep(list(loc), 3))

#-------- nAlleles() ------------
# All markers have 2 alleles
stopifnot(identical(nAlleles(x), c(2L,2L,2L)))

#-------- emptyMarkers() ------------
# Add genotype for indiv 1 at marker 1
genotype(x[[1]], 1, 1) = 1:2

# Check that markers 2 and 3 are empty
stopifnot(identical(emptyMarker(x), c(FALSE,TRUE,TRUE)),
          identical(emptyMarker(x[[1]]), c(FALSE,TRUE,TRUE)),
          identical(emptyMarker(x[[2]]), c(TRUE,TRUE,TRUE)),
          identical(emptyMarker(x, markers = c(3,1)), c(TRUE,FALSE)))

#-------- nTyped() ------------
stopifnot(identical(nTyped(x), c(1L,0L,0L)))

# Add genotypes for third marker
genotype(x[[1]], marker = 3, id = 1:3) = 1
genotype(x[[2]], marker = 3, id = 10) = 2

# nTyped() returns total over all components
stopifnot(identical(nTyped(x), c(1L,0L,4L)))

#-------- allowsMutations() ------------
# Marker 2 allows mutations
mutmod(x, 2) = list("prop", rate = 0.1)

stopifnot(identical(allowsMutations(x), c(FALSE,TRUE,FALSE)),
          identical(allowsMutations(x, markers = 2:3), c(TRUE,FALSE)))

#-------- isXmarker() ------------
# Make marker 3 X-linked
chrom(x[[1]], 3) = "X"
chrom(x[[2]], 3) = "X"

stopifnot(identical(isXmarker(x), c(FALSE,FALSE,TRUE)))

}
