% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedalfast_factor.R
\name{pedalfast_factor}
\alias{pedalfast_factor}
\title{PEDALFAST factor}
\usage{
pedalfast_factor(x, variable, label_with_level = FALSE, ...)
}
\arguments{
\item{x}{a vector of data}

\item{variable}{character string identifying the variable name in
\code{pedalfast_metadata} defining the levels and labels for the factor.}

\item{label_with_level}{(default to FALSE) labels will include the integer
value.  See examples.}

\item{...}{not currently used.}
}
\value{
An object of class \code{factor}
}
\description{
A flavor of the base function factor but aimed to use specific default values
for levels and labels based on the information in the
\code{\link{pedalfast_metadata}} object.
}
\examples{
data(pedalfast, pedalfast_metadata, package = "pedalfast.data")

# The Motor GCS in the emergency department is reported as an integer value.
str(pedalfast$gcsmotored)

# Each integer value a specific meaning
pedalfast_metadata[grepl("gcsmotored", pedalfast_metadata$variable), ]

# Creating the factor in base R

pedalfast_factor(x = c(1, 3, 2), variable = "gcsmotored")
pedalfast_factor(x = c(1, 3, 2), variable = "gcsmotored", label_with_level = TRUE)


}
\references{
Bennett TD, Dixon RR, Kartchner C, DeWitt PE, Sierra Y, Ladell D, Kempe A,
Runyan DK, Dean JM, Keenan HT. Functional Status Scale in Children With
Traumatic Brain Injury: A Prospective Cohort Study. Pediatr Crit Care Med.
2016 Dec;17(12):1147-1156. doi: 10.1097/PCC.0000000000000934. PMID: 27753754;
PMCID: PMC5138132.

Pollack MM, Holubkov R, Funai T, et al. Pediatric intensive care outcomes:
development of new morbidities during pediatric critical care. Pediatr Crit
Care Med. 2014;15(9):821-827. doi:10.1097/PCC.0000000000000250
}
