% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_fitMethods.R
\name{plot.pdynmc}
\alias{plot.pdynmc}
\title{Plot Coefficient Estimates and Corresponding Ranges of Fitted Model.}
\usage{
\method{plot}{pdynmc}(
  x,
  type = "fire",
  include.dum = FALSE,
  include.fur.con = FALSE,
  col.coefRange = 1,
  col.coefInitial = "darkgrey",
  col.coefEst = "royalblue",
  boxplot.coef = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class `pdynmc`. The function requires
twostep or iterative GMM estimates.}

\item{type}{Wether to plot fitted values against residuals (argument
'fire'; default) or coefficient ranges (argument 'coef.range';
this requires twostep or iterative GMM estimates.}

\item{include.dum}{Include estimates of parameters corresponding to time
dummies (defaults to 'FALSE'; requires 'type = coef.range').}

\item{include.fur.con}{Include estimates of parameters corresponding to
further controls (defaults to 'FALSE'; requires 'type = coef.range').}

\item{col.coefRange}{Specify color for plotting range of coefficient
estimates (defaults to 'black'; requires 'type = coef.range').}

\item{col.coefInitial}{Specify color for plotting initial coefficient
estimates (defaults to 'darkgrey'; requires 'type = coef.range').}

\item{col.coefEst}{Specify color for plotting coefficient estimate
(defaults to 'royalblue'; requires 'type = coef.range').}

\item{boxplot.coef}{Wether to draw boxplots for coefficient estimates
(defaults to 'FALSE'); requires iterative GMM with at least 10
iterations and argument 'type = coef.range'. Proceed with caution
as this argument is experimental.}

\item{...}{further arguments.}
}
\value{
Plot fitted values against residuals ('type = fire') or
   coefficient estimates and coefficient estimate ranges
   ('type = coef.range') for object of class `pdynmc`. The latter
   plot requires twostep or iterative GMM estimates.
}
\description{
\code{plot.pdynmc} Plot coefficient estimates and corresponding
   coefficient estimate ranges for objects of class `pdynmc`.
}
\examples{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])
 dat <- dat[c(1:140), ]

## Code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "twostep",
    opt.meth = "none")
 plot(m1)
 plot(m1, type = "coef.range")
}

\donttest{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])

## Further code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "iterative",
    opt.meth = "none")
 plot(m1)
 plot(m1, type = "coef.range")
}
}


}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
\author{
Markus Fritsch and Joachim Schnurbus
}
