% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_spread.R
\name{summ_spread}
\alias{summ_spread}
\alias{summ_sd}
\alias{summ_var}
\alias{summ_iqr}
\alias{summ_mad}
\alias{summ_range}
\title{Summarize distribution with spread}
\usage{
summ_spread(f, method = "sd")

summ_sd(f)

summ_var(f)

summ_iqr(f)

summ_mad(f)

summ_range(f)
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{method}{Method of spread computation. Should be one of "sd", "var",
"iqr", "mad", "range".}
}
\value{
All functions return a single number representing a spread of
distribution.
}
\description{
Functions to compute spread (variability, dispersion) of distribution (i.e.
"how wide it is spread"). \code{summ_spread()} is a wrapper for respective
\verb{summ_*()} functions (from this page) with default arguments.
}
\details{
\code{summ_sd()} computes distribution's standard deviation.

\code{summ_var()} computes distribution's variance.

\code{summ_iqr()} computes distribution's interquartile range. Essentially, it is
a \code{as_q(f)(0.75) - as_q(f)(0.25)}.

\code{summ_mad()} computes distribution's \emph{median} absolute deviation around the
distribution's \emph{median}.

\code{summ_range()} computes range length (difference between maximum and minimum)
of "x" values within region of positive probability. \strong{Note} that this might
differ from length of \link[=meta_support]{support} because the latter might be
affected by tails with zero probability (see Examples).
}
\examples{
# Type "continuous"
d_norm <- as_d(dnorm)
  # The same as `summ_spread(d_norm, method = "sd")`
summ_sd(d_norm)
summ_var(d_norm)
summ_iqr(d_norm)
summ_mad(d_norm)
summ_range(d_norm)

# Type "discrete"
d_pois <- as_d(dpois, lambda = 10)
summ_sd(d_pois)
summ_var(d_pois)
summ_iqr(d_pois)
summ_mad(d_pois)
summ_range(d_pois)

# Difference of `summ_range(f)` and `diff(meta_support(f))`
zero_tails <- new_d(data.frame(x = 1:5, y = c(0, 0, 1, 0, 0)), "continuous")
  # This returns difference between 5 and 1
diff(meta_support(zero_tails))
  # This returns difference between 2 and 4 as there are zero-probability
  # tails
summ_range(zero_tails)

}
\seealso{
\code{\link[=summ_center]{summ_center()}} for computing distribution's center, \code{\link[=summ_moment]{summ_moment()}}
for general moments.

Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_pval}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()}
}
\concept{summary functions}
