% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pima}
\alias{pima}
\title{Pima Indians Diabetes Data}
\format{
A data frame with 768 observations on 9 variables.
\itemize{
  \item \code{pregnant} Number of times pregnant.
  \item \code{glucose} Plasma glucose concentration (glucose tolerance test).
  \item \code{pressure} Diastolic blood pressure (mm Hg).
  \item \code{triceps} Triceps skin fold thickness (mm).
  \item \code{insulin} 2-Hour serum insulin (mu U/ml).
  \item \code{mass} Body mass index (weight in kg/(height in m)^2).
  \item \code{pedigree} Diabetes pedigree function.
  \item \code{age} Age (years).
  \item \code{diabetes} Factor indicating the diabetes test result (\code{neg}/\code{pos}).
}
}
\usage{
data(pima)
}
\description{
Diabetes test results collected by the the US National Institute of Diabetes
and Digestive and Kidney Diseases from a population of women who were at
least 21 years old, of Pima Indian heritage, and living near Phoenix,
Arizona. The data were taken directly from
\code{\link[mlbench]{PimaIndiansDiabetes2}}.
}
\examples{
head(pima)

}
\references{
Newman, D.J. & Hettich, S. & Blake, C.L. & Merz, C.J. (1998). UCI Repository
of machine learning databases
[http://www.ics.uci.edu/~mlearn/MLRepository.html]. Irvine, CA: University of
California, Department of Information and Computer Science.

Brian D. Ripley (1996), Pattern Recognition and Neural Networks, Cambridge
University Press, Cambridge.

Grace Whaba, Chong Gu, Yuedong Wang, and Richard Chappell (1995), Soft
Classification a.k.a. Risk Estimation via Penalized Log Likelihood and
Smoothing Spline Analysis of Variance, in D. H. Wolpert (1995), The
Mathematics of Generalization, 331-359, Addison-Wesley, Reading, MA.

Friedrich Leisch & Evgenia Dimitriadou (2010). mlbench: Machine Learning
Benchmark Problems. R package version 2.1-1.
}
\keyword{datasets}
