% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pdols.R
\name{pdols}
\alias{pdols}
\title{Cointegration Vector Estimation by Panel DOLS}
\usage{
pdols(formula, data, index, p, icase = c("noconstant", "constant", "trend"))
}
\arguments{
\item{formula}{An object of class formula. Note, pdols does not know how to deal with factors.}

\item{data}{A data frame in long panel format where each period of data is a seperate row for each individual.}

\item{index}{A vector of two strings for the individual and the time column names.}

\item{p}{An integer indicating the number of leads and lags to include in the regression.}

\item{icase}{One of the following character strings "noconstant", "constant", or "trend". Specifying "trend" also includes a constant in the estimation.}
}
\value{
\code{pdols} returns an object of class pdols with methods print, summary and coef.
This object contains a list with the dynamic OLS coefficients for each individual, as well as pooled ordinary and common time effects dols estimates of the coefficients. For more details, please refer to Mark and Sul (2003), <DOI:10.1111/j.1468-0084.2003.00066.x>.
Two standard errors are reported. The first is based on Andrews and Monahan's Pre-whitening methods and the second is based on parametric correction.
}
\description{
\code{pdols} estimates panel data cointegrating relationships following the estimator of Mark and Sul (2003), <DOI:10.1111/j.1468-0084.2003.00066.x>.
}
\examples{
data("marksul2003")
result <- pdols(formula = Y ~ X + Z,
                index = c("Country", "Year"),
                data = marksul2003,
                p = 2,
                icase = "constant")
print(result)
}
\references{
Mark, N. C. and Sul, D. (2003), Cointegration Vector Estimation by Panel DOLS and Long-run Money Demand. Oxford Bulletin of Economics and Statistics, 65: 655-680. <DOI:10.1111/j.1468-0084.2003.00066.x>
}

