% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{rExamples}
\alias{rExamples}
\title{Several example spectral matrices}
\usage{
rExamples(n, example = c("heaviSine", "bumps", "two-cats", "gaussian"), ...)
}
\arguments{
\item{n}{number of time series observations to be generated.}

\item{example}{the example spectral matrix, one of \code{'heaviSine'}, \code{'bumps'}, \code{'two-cats'} or \code{'gaussian'}.}

\item{...}{additional arguments passed on to \code{\link{pdPgram}}.}
}
\value{
Returns a list with four components:
   \item{\code{f} }{ example spectral matrix, \code{f} is a \code{(d, d, length(freq))}-dimensional array, corresponding
   to a \eqn{(d \times d)}-dimensional spectral matrix at the Fourier frequencies \code{freq}.}
   \item{\code{freq} }{ vector of Fourier frequencies from zero to \eqn{\pi}.}
   \item{\code{per} }{ multitaper HPD periodogram of the generated time series, by default pre-smoothed using \code{B = d}
   DPSS tapering functions, see \code{\link{pdPgram}} for details.}
   \item{\code{ts} }{ generated time series observations, the \code{d} columns correspond to the components of
    the multivariate time series.}
}
\description{
\code{rExamples()} generates stationary time series observations from several example HPD spectral matrices
for testing and simulation purposes. For more details, we refer to the simulation studies in (Chau and von Sachs, 2017).
}
\details{
The examples include: (i) a \eqn{(3 \times 3)} heaviSine HPD spectral matrix consisting of smooth sinosoids with a break,
(ii) a \eqn{(3 \times 3)} bumps HPD spectral matrix containing peaks and bumps of various smoothness degrees, (iii) a
\eqn{(3 \times 3)} two-cats HPD spectral matrix visualizing the contour of two side-by-side cats, with inhomogeneous
smoothness across frequency, and (iv) a \eqn{(2 \times 2)} Gaussian HPD spectral matrix consisting of smooth random Gaussian
functions. The time series observations are generated via the Cram\'er representation based on the transfer function of
the example spectral matrix and complex normal random variates.
}
\examples{
example <- rExamples(100, example = "bumps")
ts.plot(Re(example$ts)) # plot generated time series.

}
\references{
Chau, J. and von Sachs, R. (2017). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{pdPgram}}
}
