% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_estimation.R
\name{approx_or}
\alias{approx_or}
\title{Approximate a linear model for a series of logical OR statements}
\usage{
approx_or(
  means,
  covs,
  n,
  predictors,
  add_intercept = TRUE,
  verbose = FALSE,
  response_assumption = "binary",
  ...
)
}
\arguments{
\item{means}{vector of predictor and response means with the last m
means being the means of m binary responses to combine in a
logical OR statement.}

\item{covs}{a matrix of the covariance of all model predictors and the
responses with the order of rows/columns corresponding to the order of
\code{means}.}

\item{n}{sample size.}

\item{predictors}{list of objects of class \code{predictor} corresponding
to the order of the predictors in \code{means}.}

\item{add_intercept}{logical. Should the linear model add an intercept term?}

\item{verbose}{should output be printed to console?}

\item{response_assumption}{character. Either \code{"binary"} or
\code{"continuous"}. If \code{"binary"}, specific calculations will be done
to estimate product means and variances.}

\item{...}{additional arguments}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{approx_or} approximates the linear model for a disjunction of m
  phenotypes as a function of a set of predictors.
}
\references{
{

  \insertRef{wolf_using_2021}{pcsstools}
  
}
}
