% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing_fun.R
\name{pcr_wilcox}
\alias{pcr_wilcox}
\title{Wilcoxon test qPCR data}
\usage{
pcr_wilcox(df, group_var, reference_gene, reference_group, ...)
}
\arguments{
\item{df}{A data.frame of \eqn{C_T} values with genes in the columns and samples
in rows rows}

\item{group_var}{A character vector of a grouping variable. The length of
this variable should equal the number of rows of df}

\item{reference_gene}{A character string of the column name of a control gene}

\item{reference_group}{A character string of the control group in group_var}

\item{...}{Other arguments to \code{\link[stats]{wilcox.test}}}
}
\value{
A data.frame of 5 columns
\itemize{
  \item gene The column names of df. reference_gene is dropped
  \item estimate The estimate for each term
  \item p_value The p-value for each term
  \item lower The low 95\% confidence interval
  \item upper The high 95\% confidence interval
}
}
\description{
Wilcoxon test qPCR data
}
\examples{
# locate and read data
fl <- system.file('extdata', 'ct4.csv', package = 'pcr')
ct4 <- readr::read_csv(fl)

# make group variable
group <- rep(c('control', 'treatment'), each = 12)

# test
pcr_wilcox(ct4,
           group_var = group,
           reference_gene = 'ref',
           reference_group = 'control')

# test using wilcox.test method
pcr_test(ct4,
         group_var = group,
         reference_gene = 'ref',
         reference_group = 'control',
         test = 'wilcox.test')

}
