\name{create.tab}
\alias{create.tab}
\title{
Generate a summary table file for arm-based method
}
\description{
\code{creat.tab} generates a summary table file from the result file given by function \code{\link{nma.ab}}. In the table file, diagonal elements are estimated event rates; upper and lower triangular elements show the RRs, RDs, or ORs with corresponding credible interval or standard error.
}
\usage{
create.tab(summary.stat, type = "CI", compare = 1, f.name = "", trtname,
           order = TRUE, o.path = getwd())
}
\arguments{
  \item{summary.stat}{
  a data frame read from the summary result file generated by function \code{\link{nma.ab}}. We can use function \code{read.table} to import the file.
}
  \item{type}{
  a charater string. It should be set as either \code{"CI"} (the default) or \code{"SE"}. If set as \code{"CI"}, credible interval would be given following the estimated value in the output table file; otherwise, estimated value would be followed by corresponding standard error.
}
  \item{compare}{
  an integer chosen from \code{1} (the default), \code{2}, \code{3}, \code{4}, \code{5}, and \code{6}. \code{1} stands for upper triangular elements in the table being RR and lower being RD; \code{2} for upper RD and lower RR; \code{3} for upper RR and lower OR; \code{4} for upper OR and lower RR; \code{5} for upper RD and lower OR; \code{6} for upper OR and lower RD.
}
  \item{f.name}{
  a character string indicating the name of generated table file. The default is an empty character.
}
  \item{trtname}{
  a vector of character string indicating the treatment names, which are shown in the result table as row and column names. The default is "treat1", "treat2", and so on.
}
  \item{order}{
  logical. If \code{TRUE} (the default),  lower treatment ID is compared to higher treatment ID for RRs, RDs or ORs in the off-diagonal elements in result table; otherwise, higher treatment ID is compared to lower one for corresponding effect size.
}
  \item{o.path}{
  output path. If not specified, it would be set as the working directory before runing this function.
}
}
\value{
A file containing the summary table, with diagonal elements being estimated event rates and off-diagonal elements being RRs, RDs, or ORs with their credible intervals or standard errors.
}
\references{
Zhang J, Carlin BP, Neaton JD, Soon GG, Nie L, Kane R, Virnig BA and Chu H. "Network meta-analysis of randomized clinical trials: Reporting the proper summaries." \emph{Clinical Trials} 2013.
}
\author{
Lifeng Lin, Jing Zhang, and Haitao Chu.
}


\examples{
## summary RR-RD table for network Ara 2009
data(Ara09)
attach(Ara09)
nma.ab(s.id = Study.ID, t.id = Treatment, event.n = r, total.n = n,
       f.name = "Ara09_", n.iter = 2000, dic = FALSE)
detach(Ara09)
create.tab(summary.stat = read.table("Ara09_Summary.stat", header = TRUE),
           type = "SE", f.name = "Ara09-")

## summary RR-RD table for network Lam 2007
data(Lam07.Summary)
data(Lam07)
create.tab(summary.stat = Lam07.Summary, compare = 3, f.name = "Lam07-",
           trtname = Lam07$trtname, order = FALSE)
}
