% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_pk.R
\name{C_pk}
\alias{C_pk}
\title{\eqn{C_{pk}}}
\usage{
C_pk(mu, sigma, lsl, usl, dl)
}
\arguments{
\item{mu}{\code{numeric}.}

\item{sigma}{\code{numeric}.}

\item{lsl}{\code{numeric}.}

\item{usl}{\code{numeric}.}

\item{dl}{\code{numeric}. Conventionally set to 6. Must be greater than 0.}
}
\value{
\code{double}.
}
\description{
\deqn{C_{pk} = \min(C_{pl}, C_{pu})}

Note. This function allows for negative \eqn{C_{pk}} values.

Only vectors of length 1 are recycled.

\code{NA}'s take precedence over \code{NaN}'s, e.g. \code{NaN + NA} will output \code{NA}.

Yields \code{NaN} if \code{sigma} equals 0.
}
\examples{
set.seed(1L)
data = rnorm(n = 30L, mean = 3., sd = 1.)
C_pk(mu = mean(data), sigma = sd(data), lsl = 0., usl = 6., dl = 6.)
# [1] 1.052367

}
\references{
Montgomery, D. C. (2019). \emph{Introduction to statistical quality  control} (8th ed.). Wiley. ISBN: 978-1-119-39930-8
}
\seealso{
\code{\link[=C_pl]{C_pl()}}, \code{\link[=C_pu]{C_pu()}}
}
