% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{plotCSregs}
\alias{plotCSregs}
\title{The plot of the Central Similarity (CS) Proximity Regions for a 2D data set - multiple triangle case}
\usage{
plotCSregs(
  Xp,
  Yp,
  t,
  M = c(1, 1, 1),
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points for which CS proximity regions are constructed.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.}

\item{asp}{A \code{numeric} value, giving the aspect ratio \eqn{y/x} (default is \code{NA}), see the official help page for \code{asp} by
typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the \code{Xp} points, Delaunay triangles based on \code{Yp} and also the CS proximity regions
for \code{Xp} points inside the convex hull of \code{Yp} points
}
\description{
Plots the points in and outside of the Delaunay triangles based on \code{Yp} points which partition
the convex hull of \code{Yp} points and also plots the CS proximity regions
for \code{Xp} points and the Delaunay triangles based on \code{Yp} points.

CS proximity regions are constructed with respect to the Delaunay triangles with the expansion parameter \eqn{t>0}.

Edge regions in each triangle is based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of each Delaunay triangle
(default for \eqn{M=(1,1,1)} which is the center of mass of the triangle).

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}) more on the CS proximity regions.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)
tau<-1.5  #try also tau<-2

plotCSregs(Xp,Yp,tau,M,xlab="",ylab="")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSregs.tri}}, \code{\link{plotASregs}} and \code{\link{plotPEregs}}
}
\author{
Elvan Ceyhan
}
