% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNASbastri}
\alias{IndNASbastri}
\title{The indicator for the presence of an arc from a point to another for Arc Slice Proximity Catch Digraphs
(AS-PCDs) - basic triangle case}
\usage{
IndNASbastri(pt1, pt2, c1, c2, M = "CC", rv = NULL)
}
\arguments{
\item{pt1}{A 2D point whose AS proximity region is constructed.}

\item{pt2}{A 2D point. The function determines whether \code{pt2} is inside the AS proximity region of
\code{pt1} or not.}

\item{c1, c2}{Positive real numbers representing the top vertex in basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))},
\code{c1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}}

\item{M}{"CC" which stands for circumcenter or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M}="CC" i.e. the circumcenter of \eqn{T_b}}

\item{rv}{The index of the \code{M}-vertex region in \eqn{T_b} containing the point, either 1, 2, 3 or \code{NULL}
(default is \code{NULL})}
}
\value{
\eqn{I(pt2 \in N_{AS}(pt1))} for points \code{pt1} and \code{pt2}, that is, returns 1 if \code{pt2} is in NAS(\code{pt1})
(i.e., if there is an arc from pt1 to pt2), returns 0 otherwise.
}
\description{
Returns \eqn{I(pt2 \in N_{AS}(pt1))} for points \code{pt1} and \code{pt2}, that is, returns 1 if \code{pt2} is in NAS(\code{pt1}), returns 0
otherwise, where \eqn{N_{AS}(x)} is the AS proximity region for point \eqn{x}.

AS proximity region is constructed in the basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \code{c1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Vertex regions are based on the center \code{M}="CC" for circumcenter of \eqn{T_b};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of \eqn{T_b}; default is \code{M}="CC" i.e. circumcenter of \eqn{T_b}.
\code{rv} is the index of the vertex region \code{pt1} resides, with default=\code{NULL}.

If \code{pt1} and \code{pt2} are distint and either of them are outside \eqn{T_b}, the function returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

Any given triangle can be mapped to the basic triangle
by a combination of rigid body motions (i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle. Hence basic triangle is useful for simulation
studies under the uniformness hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.2)

P1<-as.numeric(runif.bastri(1,c1,c2)$g)
P2<-as.numeric(runif.bastri(1,c1,c2)$g)
IndNASbastri(P1,P2,c1,c2,M)

P1<-c(.3,.2)
P2<-c(.6,.2)
IndNASbastri(P1,P2,c1,c2,M)

#or try
Rv<-rv.bastriCC(P1,c1,c2)$rv
IndNASbastri(P1,P2,c1,c2,M,Rv)

P1<-c(.3,.2)
P2<-c(.8,.2)
IndNASbastri(P1,P2,c1,c2,M)

P3<-c(.5,.4)
IndNASbastri(P1,P3,c1,c2,M)

P4<-c(1.5,.4)
IndNASbastri(P1,P4,c1,c2,M)
IndNASbastri(P4,P4,c1,c2,M)

c1<-.4; c2<-.6;
P1<-c(.3,.2)
P2<-c(.6,.2)
IndNASbastri(P1,P2,c1,c2,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNAStri}} and \code{\link{NAStri}}
}
