% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_blacs.r
\name{gridinfo}
\alias{gridinfo}
\alias{base.blacs}
\alias{blacs}
\title{Get BLACS Context Grid Information}
\usage{
base.blacs(ICTXT = 0)

blacs(ICTXT = 0)
}
\arguments{
\item{ICTXT}{BLACS context number.}
}
\value{
Returns a list with 5 elements: \code{NPROW} and \code{NPCOL}, the
number of process rows and columns respectively; \code{ICTXT}, the
associated BLACS context number; \code{MYROW} and \code{MYCOL}, the current
process' row and column position in the process grid.
}
\description{
Grabs the existing BLACS context grid information.
}
\details{
BLACS contexts have important internal use, and advanced users familiar with
ScaLAPACK might find some advantage in directly manipulating these process
grids. Most users should not need to directly manage BLACS contexts, in this
function or elsewhere.

The function effectively serves as a shorthand for

\code{eval(parse(text=paste(".__blacs_gridinfo_", ICTXT, sep="")))}
}
\examples{
spmd.code <- "
  suppressMessages(library(pbdMPI))
  suppressMessages(library(pbdBASE))
  init.grid()

  mygrid <- blacs(0)
  comm.print(mygrid, all.rank = TRUE)

  finalize()
"
pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
\keyword{BLACS}
