% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{sagemakerfeaturestoreruntime}
\alias{sagemakerfeaturestoreruntime}
\title{Amazon SageMaker Feature Store Runtime}
\usage{
sagemakerfeaturestoreruntime(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Contains all data plane API operations and data types for the Amazon
SageMaker Feature Store. Use this API to put, delete, and retrieve (get)
features from a feature store.

Use the following operations to configure your \code{OnlineStore} and
\code{OfflineStore} features, and to create and manage feature groups:
\itemize{
\item \href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFeatureGroup.html}{CreateFeatureGroup}
\item \href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteFeatureGroup.html}{DeleteFeatureGroup}
\item \href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFeatureGroup.html}{DescribeFeatureGroup}
\item \href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListFeatureGroups.html}{ListFeatureGroups}
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- sagemakerfeaturestoreruntime(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:sagemakerfeaturestoreruntime_batch_get_record]{batch_get_record} \tab Retrieves a batch of Records from a FeatureGroup\cr
\link[paws.machine.learning:sagemakerfeaturestoreruntime_delete_record]{delete_record} \tab Deletes a Record from a FeatureGroup in the OnlineStore\cr
\link[paws.machine.learning:sagemakerfeaturestoreruntime_get_record]{get_record} \tab Use for OnlineStore serving from a FeatureStore\cr
\link[paws.machine.learning:sagemakerfeaturestoreruntime_put_record]{put_record} \tab The PutRecord API is used to ingest a list of Records into your feature group
}
}

\examples{
\dontrun{
svc <- sagemakerfeaturestoreruntime()
svc$batch_get_record(
  Foo = 123
)
}

}
