% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{marketplaceentitlementservice}
\alias{marketplaceentitlementservice}
\title{AWS Marketplace Entitlement Service}
\usage{
marketplaceentitlementservice()
}
\description{
This reference provides descriptions of the AWS Marketplace Entitlement
Service API.

AWS Marketplace Entitlement Service is used to determine the entitlement
of a customer to a given product. An entitlement represents capacity in
a product owned by the customer. For example, a customer might own some
number of users or seats in an SaaS application or some amount of data
capacity in a multi-tenant database.

\strong{Getting Entitlement Records}
\itemize{
\item \emph{GetEntitlements}- Gets the entitlements for a Marketplace product.
}
}
\section{Operations}{

\tabular{ll}{
\link[=marketplaceentitlementservice_get_entitlements]{get_entitlements} \tab GetEntitlements retrieves entitlement values for a given product
}
}

\examples{
\donttest{svc <- marketplaceentitlementservice()
svc$get_entitlements(
  Foo = 123
)}

}
