% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{securityhub}
\alias{securityhub}
\title{AWS SecurityHub}
\usage{
securityhub()
}
\description{
AWS Security Hub provides you with a comprehensive view of your security
state within AWS and your compliance with the security industry
standards and best practices. Security Hub collects security data from
across AWS accounts, services, and supported third-party partners and
helps you analyze your security trends and identify the highest priority
security issues. For more information, see \url{AWS Security Hub UserGuide}.
}
\section{Operations}{

\tabular{ll}{
\link[=securityhub_accept_invitation]{accept_invitation} \tab Accepts the invitation to be monitored by a master SecurityHub account \cr
\link[=securityhub_batch_disable_standards]{batch_disable_standards} \tab Disables the standards specified by the standards subscription ARNs \cr
\link[=securityhub_batch_enable_standards]{batch_enable_standards} \tab Enables the standards specified by the standards ARNs \cr
\link[=securityhub_batch_import_findings]{batch_import_findings} \tab Imports security findings that are generated by the integrated third-party products into Security Hub \cr
\link[=securityhub_create_insight]{create_insight} \tab Creates an insight, which is a consolidation of findings that identifies a security area that requires attention or intervention \cr
\link[=securityhub_create_members]{create_members} \tab Creates member Security Hub accounts in the current AWS account (which becomes the master Security Hub account) that has Security Hub enabled \cr
\link[=securityhub_decline_invitations]{decline_invitations} \tab Declines invitations that are sent to this AWS account (invitee) by the AWS accounts (inviters) that are specified by the account IDs \cr
\link[=securityhub_delete_insight]{delete_insight} \tab Deletes an insight that is specified by the insight ARN \cr
\link[=securityhub_delete_invitations]{delete_invitations} \tab Deletes invitations that are sent to this AWS account (invitee) by the AWS accounts (inviters) that are specified by their account IDs \cr
\link[=securityhub_delete_members]{delete_members} \tab Deletes the Security Hub member accounts that are specified by the account IDs \cr
\link[=securityhub_disable_import_findings_for_product]{disable_import_findings_for_product} \tab Stops you from being able to import findings generated by integrated third-party providers into Security Hub \cr
\link[=securityhub_disable_security_hub]{disable_security_hub} \tab Disables the AWS Security Hub Service \cr
\link[=securityhub_disassociate_from_master_account]{disassociate_from_master_account} \tab Disassociates the current Security Hub member account from its master account \cr
\link[=securityhub_disassociate_members]{disassociate_members} \tab Disassociates the Security Hub member accounts that are specified by the account IDs from their master account \cr
\link[=securityhub_enable_import_findings_for_product]{enable_import_findings_for_product} \tab Enables you to import findings generated by integrated third-party providers into Security Hub \cr
\link[=securityhub_enable_security_hub]{enable_security_hub} \tab Enables the AWS Security Hub service \cr
\link[=securityhub_get_enabled_standards]{get_enabled_standards} \tab Lists and describes enabled standards \cr
\link[=securityhub_get_findings]{get_findings} \tab Lists and describes Security Hub-aggregated findings that are specified by filter attributes \cr
\link[=securityhub_get_insight_results]{get_insight_results} \tab Lists the results of the Security Hub insight specified by the insight ARN \cr
\link[=securityhub_get_insights]{get_insights} \tab Lists and describes insights that are specified by insight ARNs \cr
\link[=securityhub_get_invitations_count]{get_invitations_count} \tab Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation\cr
\link[=securityhub_get_master_account]{get_master_account} \tab Provides the details for the Security Hub master account to the current member account \cr
\link[=securityhub_get_members]{get_members} \tab Returns the details on the Security Hub member accounts that are specified by the account IDs \cr
\link[=securityhub_invite_members]{invite_members} \tab Invites other AWS accounts to enable Security Hub and become Security Hub member accounts \cr
\link[=securityhub_list_enabled_products_for_import]{list_enabled_products_for_import} \tab Lists all Security Hub-integrated third-party findings providers \cr
\link[=securityhub_list_invitations]{list_invitations} \tab Lists all Security Hub membership invitations that were sent to the current AWS account \cr
\link[=securityhub_list_members]{list_members} \tab Lists details about all member accounts for the current Security Hub master account \cr
\link[=securityhub_update_findings]{update_findings} \tab Updates the AWS Security Hub-aggregated findings specified by the filter attributes \cr
\link[=securityhub_update_insight]{update_insight} \tab Updates the AWS Security Hub insight specified by the insight ARN
}
}

\examples{
\donttest{svc <- securityhub()
svc$accept_invitation(
  Foo = 123
)}

}
