# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include omics_service.R
NULL

#' Stops a multipart upload
#'
#' @description
#' Stops a multipart upload.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_abort_multipart_read_set_upload/](https://www.paws-r-sdk.com/docs/omics_abort_multipart_read_set_upload/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The sequence store ID for the store involved in the multipart upload.
#' @param uploadId &#91;required&#93; The ID for the multipart upload.
#'
#' @keywords internal
#'
#' @rdname omics_abort_multipart_read_set_upload
omics_abort_multipart_read_set_upload <- function(sequenceStoreId, uploadId) {
  op <- new_operation(
    name = "AbortMultipartReadSetUpload",
    http_method = "DELETE",
    http_path = "/sequencestore/{sequenceStoreId}/upload/{uploadId}/abort",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$abort_multipart_read_set_upload_input(sequenceStoreId = sequenceStoreId, uploadId = uploadId)
  output <- .omics$abort_multipart_read_set_upload_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$abort_multipart_read_set_upload <- omics_abort_multipart_read_set_upload

#' Accept a resource share request
#'
#' @description
#' Accept a resource share request.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_accept_share/](https://www.paws-r-sdk.com/docs/omics_accept_share/) for full documentation.
#'
#' @param shareId &#91;required&#93; The ID of the resource share.
#'
#' @keywords internal
#'
#' @rdname omics_accept_share
omics_accept_share <- function(shareId) {
  op <- new_operation(
    name = "AcceptShare",
    http_method = "POST",
    http_path = "/share/{shareId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$accept_share_input(shareId = shareId)
  output <- .omics$accept_share_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$accept_share <- omics_accept_share

#' Deletes one or more read sets
#'
#' @description
#' Deletes one or more read sets.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_batch_delete_read_set/](https://www.paws-r-sdk.com/docs/omics_batch_delete_read_set/) for full documentation.
#'
#' @param ids &#91;required&#93; The read sets' IDs.
#' @param sequenceStoreId &#91;required&#93; The read sets' sequence store ID.
#'
#' @keywords internal
#'
#' @rdname omics_batch_delete_read_set
omics_batch_delete_read_set <- function(ids, sequenceStoreId) {
  op <- new_operation(
    name = "BatchDeleteReadSet",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/readset/batch/delete",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$batch_delete_read_set_input(ids = ids, sequenceStoreId = sequenceStoreId)
  output <- .omics$batch_delete_read_set_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$batch_delete_read_set <- omics_batch_delete_read_set

#' Cancels an annotation import job
#'
#' @description
#' Cancels an annotation import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_cancel_annotation_import_job/](https://www.paws-r-sdk.com/docs/omics_cancel_annotation_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname omics_cancel_annotation_import_job
omics_cancel_annotation_import_job <- function(jobId) {
  op <- new_operation(
    name = "CancelAnnotationImportJob",
    http_method = "DELETE",
    http_path = "/import/annotation/{jobId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$cancel_annotation_import_job_input(jobId = jobId)
  output <- .omics$cancel_annotation_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$cancel_annotation_import_job <- omics_cancel_annotation_import_job

#' Cancels a run
#'
#' @description
#' Cancels a run.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_cancel_run/](https://www.paws-r-sdk.com/docs/omics_cancel_run/) for full documentation.
#'
#' @param id &#91;required&#93; The run's ID.
#'
#' @keywords internal
#'
#' @rdname omics_cancel_run
omics_cancel_run <- function(id) {
  op <- new_operation(
    name = "CancelRun",
    http_method = "POST",
    http_path = "/run/{id}/cancel",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$cancel_run_input(id = id)
  output <- .omics$cancel_run_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$cancel_run <- omics_cancel_run

#' Cancels a variant import job
#'
#' @description
#' Cancels a variant import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_cancel_variant_import_job/](https://www.paws-r-sdk.com/docs/omics_cancel_variant_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname omics_cancel_variant_import_job
omics_cancel_variant_import_job <- function(jobId) {
  op <- new_operation(
    name = "CancelVariantImportJob",
    http_method = "DELETE",
    http_path = "/import/variant/{jobId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$cancel_variant_import_job_input(jobId = jobId)
  output <- .omics$cancel_variant_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$cancel_variant_import_job <- omics_cancel_variant_import_job

#' Concludes a multipart upload once you have uploaded all the components
#'
#' @description
#' Concludes a multipart upload once you have uploaded all the components.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_complete_multipart_read_set_upload/](https://www.paws-r-sdk.com/docs/omics_complete_multipart_read_set_upload/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The sequence store ID for the store involved in the multipart upload.
#' @param uploadId &#91;required&#93; The ID for the multipart upload.
#' @param parts &#91;required&#93; The individual uploads or parts of a multipart upload.
#'
#' @keywords internal
#'
#' @rdname omics_complete_multipart_read_set_upload
omics_complete_multipart_read_set_upload <- function(sequenceStoreId, uploadId, parts) {
  op <- new_operation(
    name = "CompleteMultipartReadSetUpload",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/upload/{uploadId}/complete",
    host_prefix = "storage-",
    paginator = list()
  )
  input <- .omics$complete_multipart_read_set_upload_input(sequenceStoreId = sequenceStoreId, uploadId = uploadId, parts = parts)
  output <- .omics$complete_multipart_read_set_upload_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$complete_multipart_read_set_upload <- omics_complete_multipart_read_set_upload

#' Creates an annotation store
#'
#' @description
#' Creates an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_annotation_store/](https://www.paws-r-sdk.com/docs/omics_create_annotation_store/) for full documentation.
#'
#' @param reference The genome reference for the store's annotations.
#' @param name A name for the store.
#' @param description A description for the store.
#' @param tags Tags for the store.
#' @param versionName The name given to an annotation store version to distinguish it from
#' other versions.
#' @param sseConfig Server-side encryption (SSE) settings for the store.
#' @param storeFormat &#91;required&#93; The annotation file format of the store.
#' @param storeOptions File parsing options for the annotation store.
#'
#' @keywords internal
#'
#' @rdname omics_create_annotation_store
omics_create_annotation_store <- function(reference = NULL, name = NULL, description = NULL, tags = NULL, versionName = NULL, sseConfig = NULL, storeFormat, storeOptions = NULL) {
  op <- new_operation(
    name = "CreateAnnotationStore",
    http_method = "POST",
    http_path = "/annotationStore",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$create_annotation_store_input(reference = reference, name = name, description = description, tags = tags, versionName = versionName, sseConfig = sseConfig, storeFormat = storeFormat, storeOptions = storeOptions)
  output <- .omics$create_annotation_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_annotation_store <- omics_create_annotation_store

#' Creates a new version of an annotation store
#'
#' @description
#' Creates a new version of an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_annotation_store_version/](https://www.paws-r-sdk.com/docs/omics_create_annotation_store_version/) for full documentation.
#'
#' @param name &#91;required&#93; The name of an annotation store version from which versions are being
#' created.
#' @param versionName &#91;required&#93; The name given to an annotation store version to distinguish it from
#' other versions.
#' @param description The description of an annotation store version.
#' @param versionOptions The options for an annotation store version.
#' @param tags Any tags added to annotation store version.
#'
#' @keywords internal
#'
#' @rdname omics_create_annotation_store_version
omics_create_annotation_store_version <- function(name, versionName, description = NULL, versionOptions = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAnnotationStoreVersion",
    http_method = "POST",
    http_path = "/annotationStore/{name}/version",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$create_annotation_store_version_input(name = name, versionName = versionName, description = description, versionOptions = versionOptions, tags = tags)
  output <- .omics$create_annotation_store_version_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_annotation_store_version <- omics_create_annotation_store_version

#' Begins a multipart read set upload
#'
#' @description
#' Begins a multipart read set upload.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_multipart_read_set_upload/](https://www.paws-r-sdk.com/docs/omics_create_multipart_read_set_upload/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The sequence store ID for the store that is the destination of the
#' multipart uploads.
#' @param clientToken An idempotency token that can be used to avoid triggering multiple
#' multipart uploads.
#' @param sourceFileType &#91;required&#93; The type of file being uploaded.
#' @param subjectId &#91;required&#93; The source's subject ID.
#' @param sampleId &#91;required&#93; The source's sample ID.
#' @param generatedFrom Where the source originated.
#' @param referenceArn The ARN of the reference.
#' @param name &#91;required&#93; The name of the read set.
#' @param description The description of the read set.
#' @param tags Any tags to add to the read set.
#'
#' @keywords internal
#'
#' @rdname omics_create_multipart_read_set_upload
omics_create_multipart_read_set_upload <- function(sequenceStoreId, clientToken = NULL, sourceFileType, subjectId, sampleId, generatedFrom = NULL, referenceArn = NULL, name, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateMultipartReadSetUpload",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/upload",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$create_multipart_read_set_upload_input(sequenceStoreId = sequenceStoreId, clientToken = clientToken, sourceFileType = sourceFileType, subjectId = subjectId, sampleId = sampleId, generatedFrom = generatedFrom, referenceArn = referenceArn, name = name, description = description, tags = tags)
  output <- .omics$create_multipart_read_set_upload_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_multipart_read_set_upload <- omics_create_multipart_read_set_upload

#' Creates a reference store
#'
#' @description
#' Creates a reference store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_reference_store/](https://www.paws-r-sdk.com/docs/omics_create_reference_store/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the store.
#' @param description A description for the store.
#' @param sseConfig Server-side encryption (SSE) settings for the store.
#' @param tags Tags for the store.
#' @param clientToken To ensure that requests don't run multiple times, specify a unique token
#' for each request.
#'
#' @keywords internal
#'
#' @rdname omics_create_reference_store
omics_create_reference_store <- function(name, description = NULL, sseConfig = NULL, tags = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "CreateReferenceStore",
    http_method = "POST",
    http_path = "/referencestore",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$create_reference_store_input(name = name, description = description, sseConfig = sseConfig, tags = tags, clientToken = clientToken)
  output <- .omics$create_reference_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_reference_store <- omics_create_reference_store

#' You can optionally create a run group to limit the compute resources for
#' the runs that you add to the group
#'
#' @description
#' You can optionally create a run group to limit the compute resources for the runs that you add to the group.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_run_group/](https://www.paws-r-sdk.com/docs/omics_create_run_group/) for full documentation.
#'
#' @param name A name for the group.
#' @param maxCpus The maximum number of CPUs that can run concurrently across all active
#' runs in the run group.
#' @param maxRuns The maximum number of runs that can be running at the same time.
#' @param maxDuration The maximum time for each run (in minutes). If a run exceeds the maximum
#' run time, the run fails automatically.
#' @param tags Tags for the group.
#' @param requestId &#91;required&#93; To ensure that requests don't run multiple times, specify a unique ID
#' for each request.
#' @param maxGpus The maximum number of GPUs that can run concurrently across all active
#' runs in the run group.
#'
#' @keywords internal
#'
#' @rdname omics_create_run_group
omics_create_run_group <- function(name = NULL, maxCpus = NULL, maxRuns = NULL, maxDuration = NULL, tags = NULL, requestId, maxGpus = NULL) {
  op <- new_operation(
    name = "CreateRunGroup",
    http_method = "POST",
    http_path = "/runGroup",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$create_run_group_input(name = name, maxCpus = maxCpus, maxRuns = maxRuns, maxDuration = maxDuration, tags = tags, requestId = requestId, maxGpus = maxGpus)
  output <- .omics$create_run_group_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_run_group <- omics_create_run_group

#' Creates a sequence store
#'
#' @description
#' Creates a sequence store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_sequence_store/](https://www.paws-r-sdk.com/docs/omics_create_sequence_store/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the store.
#' @param description A description for the store.
#' @param sseConfig Server-side encryption (SSE) settings for the store.
#' @param tags Tags for the store.
#' @param clientToken To ensure that requests don't run multiple times, specify a unique token
#' for each request.
#' @param fallbackLocation An S3 location that is used to store files that have failed a direct
#' upload.
#' @param eTagAlgorithmFamily The ETag algorithm family to use for ingested read sets.
#'
#' @keywords internal
#'
#' @rdname omics_create_sequence_store
omics_create_sequence_store <- function(name, description = NULL, sseConfig = NULL, tags = NULL, clientToken = NULL, fallbackLocation = NULL, eTagAlgorithmFamily = NULL) {
  op <- new_operation(
    name = "CreateSequenceStore",
    http_method = "POST",
    http_path = "/sequencestore",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$create_sequence_store_input(name = name, description = description, sseConfig = sseConfig, tags = tags, clientToken = clientToken, fallbackLocation = fallbackLocation, eTagAlgorithmFamily = eTagAlgorithmFamily)
  output <- .omics$create_sequence_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_sequence_store <- omics_create_sequence_store

#' Creates a cross-account shared resource
#'
#' @description
#' Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the principal subscriber (an AWS user with a different account than the resource owner).
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_share/](https://www.paws-r-sdk.com/docs/omics_create_share/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be shared.
#' @param principalSubscriber &#91;required&#93; The principal subscriber is the account being offered shared access to
#' the resource.
#' @param shareName A name that the owner defines for the share.
#'
#' @keywords internal
#'
#' @rdname omics_create_share
omics_create_share <- function(resourceArn, principalSubscriber, shareName = NULL) {
  op <- new_operation(
    name = "CreateShare",
    http_method = "POST",
    http_path = "/share",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$create_share_input(resourceArn = resourceArn, principalSubscriber = principalSubscriber, shareName = shareName)
  output <- .omics$create_share_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_share <- omics_create_share

#' Creates a variant store
#'
#' @description
#' Creates a variant store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_variant_store/](https://www.paws-r-sdk.com/docs/omics_create_variant_store/) for full documentation.
#'
#' @param reference &#91;required&#93; The genome reference for the store's variants.
#' @param name A name for the store.
#' @param description A description for the store.
#' @param tags Tags for the store.
#' @param sseConfig Server-side encryption (SSE) settings for the store.
#'
#' @keywords internal
#'
#' @rdname omics_create_variant_store
omics_create_variant_store <- function(reference, name = NULL, description = NULL, tags = NULL, sseConfig = NULL) {
  op <- new_operation(
    name = "CreateVariantStore",
    http_method = "POST",
    http_path = "/variantStore",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$create_variant_store_input(reference = reference, name = name, description = description, tags = tags, sseConfig = sseConfig)
  output <- .omics$create_variant_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_variant_store <- omics_create_variant_store

#' Creates a workflow
#'
#' @description
#' Creates a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_create_workflow/](https://www.paws-r-sdk.com/docs/omics_create_workflow/) for full documentation.
#'
#' @param name A name for the workflow.
#' @param description A description for the workflow.
#' @param engine An engine for the workflow.
#' @param definitionZip A ZIP archive for the workflow.
#' @param definitionUri The URI of a definition for the workflow.
#' @param main The path of the main definition file for the workflow.
#' @param parameterTemplate A parameter template for the workflow.
#' @param storageCapacity The default storage capacity for the workflow runs, in gibibytes.
#' @param tags Tags for the workflow.
#' @param requestId &#91;required&#93; To ensure that requests don't run multiple times, specify a unique ID
#' for each request.
#' @param accelerators The computational accelerator specified to run the workflow.
#'
#' @keywords internal
#'
#' @rdname omics_create_workflow
omics_create_workflow <- function(name = NULL, description = NULL, engine = NULL, definitionZip = NULL, definitionUri = NULL, main = NULL, parameterTemplate = NULL, storageCapacity = NULL, tags = NULL, requestId, accelerators = NULL) {
  op <- new_operation(
    name = "CreateWorkflow",
    http_method = "POST",
    http_path = "/workflow",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$create_workflow_input(name = name, description = description, engine = engine, definitionZip = definitionZip, definitionUri = definitionUri, main = main, parameterTemplate = parameterTemplate, storageCapacity = storageCapacity, tags = tags, requestId = requestId, accelerators = accelerators)
  output <- .omics$create_workflow_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$create_workflow <- omics_create_workflow

#' Deletes an annotation store
#'
#' @description
#' Deletes an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_annotation_store/](https://www.paws-r-sdk.com/docs/omics_delete_annotation_store/) for full documentation.
#'
#' @param name &#91;required&#93; The store's name.
#' @param force Whether to force deletion.
#'
#' @keywords internal
#'
#' @rdname omics_delete_annotation_store
omics_delete_annotation_store <- function(name, force = NULL) {
  op <- new_operation(
    name = "DeleteAnnotationStore",
    http_method = "DELETE",
    http_path = "/annotationStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$delete_annotation_store_input(name = name, force = force)
  output <- .omics$delete_annotation_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_annotation_store <- omics_delete_annotation_store

#' Deletes one or multiple versions of an annotation store
#'
#' @description
#' Deletes one or multiple versions of an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_annotation_store_versions/](https://www.paws-r-sdk.com/docs/omics_delete_annotation_store_versions/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the annotation store from which versions are being deleted.
#' @param versions &#91;required&#93; The versions of an annotation store to be deleted.
#' @param force Forces the deletion of an annotation store version when imports are
#' in-progress..
#'
#' @keywords internal
#'
#' @rdname omics_delete_annotation_store_versions
omics_delete_annotation_store_versions <- function(name, versions, force = NULL) {
  op <- new_operation(
    name = "DeleteAnnotationStoreVersions",
    http_method = "POST",
    http_path = "/annotationStore/{name}/versions/delete",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$delete_annotation_store_versions_input(name = name, versions = versions, force = force)
  output <- .omics$delete_annotation_store_versions_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_annotation_store_versions <- omics_delete_annotation_store_versions

#' Deletes a genome reference
#'
#' @description
#' Deletes a genome reference.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_reference/](https://www.paws-r-sdk.com/docs/omics_delete_reference/) for full documentation.
#'
#' @param id &#91;required&#93; The reference's ID.
#' @param referenceStoreId &#91;required&#93; The reference's store ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_reference
omics_delete_reference <- function(id, referenceStoreId) {
  op <- new_operation(
    name = "DeleteReference",
    http_method = "DELETE",
    http_path = "/referencestore/{referenceStoreId}/reference/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$delete_reference_input(id = id, referenceStoreId = referenceStoreId)
  output <- .omics$delete_reference_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_reference <- omics_delete_reference

#' Deletes a genome reference store
#'
#' @description
#' Deletes a genome reference store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_reference_store/](https://www.paws-r-sdk.com/docs/omics_delete_reference_store/) for full documentation.
#'
#' @param id &#91;required&#93; The store's ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_reference_store
omics_delete_reference_store <- function(id) {
  op <- new_operation(
    name = "DeleteReferenceStore",
    http_method = "DELETE",
    http_path = "/referencestore/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$delete_reference_store_input(id = id)
  output <- .omics$delete_reference_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_reference_store <- omics_delete_reference_store

#' Deletes a workflow run
#'
#' @description
#' Deletes a workflow run.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_run/](https://www.paws-r-sdk.com/docs/omics_delete_run/) for full documentation.
#'
#' @param id &#91;required&#93; The run's ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_run
omics_delete_run <- function(id) {
  op <- new_operation(
    name = "DeleteRun",
    http_method = "DELETE",
    http_path = "/run/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$delete_run_input(id = id)
  output <- .omics$delete_run_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_run <- omics_delete_run

#' Deletes a workflow run group
#'
#' @description
#' Deletes a workflow run group.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_run_group/](https://www.paws-r-sdk.com/docs/omics_delete_run_group/) for full documentation.
#'
#' @param id &#91;required&#93; The run group's ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_run_group
omics_delete_run_group <- function(id) {
  op <- new_operation(
    name = "DeleteRunGroup",
    http_method = "DELETE",
    http_path = "/runGroup/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$delete_run_group_input(id = id)
  output <- .omics$delete_run_group_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_run_group <- omics_delete_run_group

#' Deletes a sequence store
#'
#' @description
#' Deletes a sequence store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_sequence_store/](https://www.paws-r-sdk.com/docs/omics_delete_sequence_store/) for full documentation.
#'
#' @param id &#91;required&#93; The sequence store's ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_sequence_store
omics_delete_sequence_store <- function(id) {
  op <- new_operation(
    name = "DeleteSequenceStore",
    http_method = "DELETE",
    http_path = "/sequencestore/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$delete_sequence_store_input(id = id)
  output <- .omics$delete_sequence_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_sequence_store <- omics_delete_sequence_store

#' Deletes a resource share
#'
#' @description
#' Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared resource. If you are the subscriber, this operation deletes your access to the share.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_share/](https://www.paws-r-sdk.com/docs/omics_delete_share/) for full documentation.
#'
#' @param shareId &#91;required&#93; The ID for the resource share to be deleted.
#'
#' @keywords internal
#'
#' @rdname omics_delete_share
omics_delete_share <- function(shareId) {
  op <- new_operation(
    name = "DeleteShare",
    http_method = "DELETE",
    http_path = "/share/{shareId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$delete_share_input(shareId = shareId)
  output <- .omics$delete_share_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_share <- omics_delete_share

#' Deletes a variant store
#'
#' @description
#' Deletes a variant store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_variant_store/](https://www.paws-r-sdk.com/docs/omics_delete_variant_store/) for full documentation.
#'
#' @param name &#91;required&#93; The store's name.
#' @param force Whether to force deletion.
#'
#' @keywords internal
#'
#' @rdname omics_delete_variant_store
omics_delete_variant_store <- function(name, force = NULL) {
  op <- new_operation(
    name = "DeleteVariantStore",
    http_method = "DELETE",
    http_path = "/variantStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$delete_variant_store_input(name = name, force = force)
  output <- .omics$delete_variant_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_variant_store <- omics_delete_variant_store

#' Deletes a workflow
#'
#' @description
#' Deletes a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_delete_workflow/](https://www.paws-r-sdk.com/docs/omics_delete_workflow/) for full documentation.
#'
#' @param id &#91;required&#93; The workflow's ID.
#'
#' @keywords internal
#'
#' @rdname omics_delete_workflow
omics_delete_workflow <- function(id) {
  op <- new_operation(
    name = "DeleteWorkflow",
    http_method = "DELETE",
    http_path = "/workflow/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$delete_workflow_input(id = id)
  output <- .omics$delete_workflow_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$delete_workflow <- omics_delete_workflow

#' Gets information about an annotation import job
#'
#' @description
#' Gets information about an annotation import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_annotation_import_job/](https://www.paws-r-sdk.com/docs/omics_get_annotation_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_annotation_import_job
omics_get_annotation_import_job <- function(jobId) {
  op <- new_operation(
    name = "GetAnnotationImportJob",
    http_method = "GET",
    http_path = "/import/annotation/{jobId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_annotation_import_job_input(jobId = jobId)
  output <- .omics$get_annotation_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_annotation_import_job <- omics_get_annotation_import_job

#' Gets information about an annotation store
#'
#' @description
#' Gets information about an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_annotation_store/](https://www.paws-r-sdk.com/docs/omics_get_annotation_store/) for full documentation.
#'
#' @param name &#91;required&#93; The store's name.
#'
#' @keywords internal
#'
#' @rdname omics_get_annotation_store
omics_get_annotation_store <- function(name) {
  op <- new_operation(
    name = "GetAnnotationStore",
    http_method = "GET",
    http_path = "/annotationStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_annotation_store_input(name = name)
  output <- .omics$get_annotation_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_annotation_store <- omics_get_annotation_store

#' Retrieves the metadata for an annotation store version
#'
#' @description
#' Retrieves the metadata for an annotation store version.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_annotation_store_version/](https://www.paws-r-sdk.com/docs/omics_get_annotation_store_version/) for full documentation.
#'
#' @param name &#91;required&#93; The name given to an annotation store version to distinguish it from
#' others.
#' @param versionName &#91;required&#93; The name given to an annotation store version to distinguish it from
#' others.
#'
#' @keywords internal
#'
#' @rdname omics_get_annotation_store_version
omics_get_annotation_store_version <- function(name, versionName) {
  op <- new_operation(
    name = "GetAnnotationStoreVersion",
    http_method = "GET",
    http_path = "/annotationStore/{name}/version/{versionName}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_annotation_store_version_input(name = name, versionName = versionName)
  output <- .omics$get_annotation_store_version_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_annotation_store_version <- omics_get_annotation_store_version

#' Gets a file from a read set
#'
#' @description
#' Gets a file from a read set.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_read_set/](https://www.paws-r-sdk.com/docs/omics_get_read_set/) for full documentation.
#'
#' @param id &#91;required&#93; The read set's ID.
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#' @param file The file to retrieve.
#' @param partNumber &#91;required&#93; The part number to retrieve.
#'
#' @keywords internal
#'
#' @rdname omics_get_read_set
omics_get_read_set <- function(id, sequenceStoreId, file = NULL, partNumber) {
  op <- new_operation(
    name = "GetReadSet",
    http_method = "GET",
    http_path = "/sequencestore/{sequenceStoreId}/readset/{id}",
    host_prefix = "storage-",
    paginator = list()
  )
  input <- .omics$get_read_set_input(id = id, sequenceStoreId = sequenceStoreId, file = file, partNumber = partNumber)
  output <- .omics$get_read_set_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_read_set <- omics_get_read_set

#' Gets information about a read set activation job
#'
#' @description
#' Gets information about a read set activation job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_read_set_activation_job/](https://www.paws-r-sdk.com/docs/omics_get_read_set_activation_job/) for full documentation.
#'
#' @param id &#91;required&#93; The job's ID.
#' @param sequenceStoreId &#91;required&#93; The job's sequence store ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_read_set_activation_job
omics_get_read_set_activation_job <- function(id, sequenceStoreId) {
  op <- new_operation(
    name = "GetReadSetActivationJob",
    http_method = "GET",
    http_path = "/sequencestore/{sequenceStoreId}/activationjob/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_read_set_activation_job_input(id = id, sequenceStoreId = sequenceStoreId)
  output <- .omics$get_read_set_activation_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_read_set_activation_job <- omics_get_read_set_activation_job

#' Gets information about a read set export job
#'
#' @description
#' Gets information about a read set export job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_read_set_export_job/](https://www.paws-r-sdk.com/docs/omics_get_read_set_export_job/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The job's sequence store ID.
#' @param id &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_read_set_export_job
omics_get_read_set_export_job <- function(sequenceStoreId, id) {
  op <- new_operation(
    name = "GetReadSetExportJob",
    http_method = "GET",
    http_path = "/sequencestore/{sequenceStoreId}/exportjob/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_read_set_export_job_input(sequenceStoreId = sequenceStoreId, id = id)
  output <- .omics$get_read_set_export_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_read_set_export_job <- omics_get_read_set_export_job

#' Gets information about a read set import job
#'
#' @description
#' Gets information about a read set import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_read_set_import_job/](https://www.paws-r-sdk.com/docs/omics_get_read_set_import_job/) for full documentation.
#'
#' @param id &#91;required&#93; The job's ID.
#' @param sequenceStoreId &#91;required&#93; The job's sequence store ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_read_set_import_job
omics_get_read_set_import_job <- function(id, sequenceStoreId) {
  op <- new_operation(
    name = "GetReadSetImportJob",
    http_method = "GET",
    http_path = "/sequencestore/{sequenceStoreId}/importjob/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_read_set_import_job_input(id = id, sequenceStoreId = sequenceStoreId)
  output <- .omics$get_read_set_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_read_set_import_job <- omics_get_read_set_import_job

#' Gets details about a read set
#'
#' @description
#' Gets details about a read set.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_read_set_metadata/](https://www.paws-r-sdk.com/docs/omics_get_read_set_metadata/) for full documentation.
#'
#' @param id &#91;required&#93; The read set's ID.
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_read_set_metadata
omics_get_read_set_metadata <- function(id, sequenceStoreId) {
  op <- new_operation(
    name = "GetReadSetMetadata",
    http_method = "GET",
    http_path = "/sequencestore/{sequenceStoreId}/readset/{id}/metadata",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_read_set_metadata_input(id = id, sequenceStoreId = sequenceStoreId)
  output <- .omics$get_read_set_metadata_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_read_set_metadata <- omics_get_read_set_metadata

#' Gets a reference file
#'
#' @description
#' Gets a reference file.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_reference/](https://www.paws-r-sdk.com/docs/omics_get_reference/) for full documentation.
#'
#' @param id &#91;required&#93; The reference's ID.
#' @param referenceStoreId &#91;required&#93; The reference's store ID.
#' @param range The range to retrieve.
#' @param partNumber &#91;required&#93; The part number to retrieve.
#' @param file The file to retrieve.
#'
#' @keywords internal
#'
#' @rdname omics_get_reference
omics_get_reference <- function(id, referenceStoreId, range = NULL, partNumber, file = NULL) {
  op <- new_operation(
    name = "GetReference",
    http_method = "GET",
    http_path = "/referencestore/{referenceStoreId}/reference/{id}",
    host_prefix = "storage-",
    paginator = list()
  )
  input <- .omics$get_reference_input(id = id, referenceStoreId = referenceStoreId, range = range, partNumber = partNumber, file = file)
  output <- .omics$get_reference_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_reference <- omics_get_reference

#' Gets information about a reference import job
#'
#' @description
#' Gets information about a reference import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_reference_import_job/](https://www.paws-r-sdk.com/docs/omics_get_reference_import_job/) for full documentation.
#'
#' @param id &#91;required&#93; The job's ID.
#' @param referenceStoreId &#91;required&#93; The job's reference store ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_reference_import_job
omics_get_reference_import_job <- function(id, referenceStoreId) {
  op <- new_operation(
    name = "GetReferenceImportJob",
    http_method = "GET",
    http_path = "/referencestore/{referenceStoreId}/importjob/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_reference_import_job_input(id = id, referenceStoreId = referenceStoreId)
  output <- .omics$get_reference_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_reference_import_job <- omics_get_reference_import_job

#' Gets information about a genome reference's metadata
#'
#' @description
#' Gets information about a genome reference's metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_reference_metadata/](https://www.paws-r-sdk.com/docs/omics_get_reference_metadata/) for full documentation.
#'
#' @param id &#91;required&#93; The reference's ID.
#' @param referenceStoreId &#91;required&#93; The reference's reference store ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_reference_metadata
omics_get_reference_metadata <- function(id, referenceStoreId) {
  op <- new_operation(
    name = "GetReferenceMetadata",
    http_method = "GET",
    http_path = "/referencestore/{referenceStoreId}/reference/{id}/metadata",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_reference_metadata_input(id = id, referenceStoreId = referenceStoreId)
  output <- .omics$get_reference_metadata_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_reference_metadata <- omics_get_reference_metadata

#' Gets information about a reference store
#'
#' @description
#' Gets information about a reference store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_reference_store/](https://www.paws-r-sdk.com/docs/omics_get_reference_store/) for full documentation.
#'
#' @param id &#91;required&#93; The store's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_reference_store
omics_get_reference_store <- function(id) {
  op <- new_operation(
    name = "GetReferenceStore",
    http_method = "GET",
    http_path = "/referencestore/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_reference_store_input(id = id)
  output <- .omics$get_reference_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_reference_store <- omics_get_reference_store

#' Gets information about a workflow run
#'
#' @description
#' Gets information about a workflow run.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_run/](https://www.paws-r-sdk.com/docs/omics_get_run/) for full documentation.
#'
#' @param id &#91;required&#93; The run's ID.
#' @param export The run's export format.
#'
#' @keywords internal
#'
#' @rdname omics_get_run
omics_get_run <- function(id, export = NULL) {
  op <- new_operation(
    name = "GetRun",
    http_method = "GET",
    http_path = "/run/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$get_run_input(id = id, export = export)
  output <- .omics$get_run_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_run <- omics_get_run

#' Gets information about a workflow run group
#'
#' @description
#' Gets information about a workflow run group.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_run_group/](https://www.paws-r-sdk.com/docs/omics_get_run_group/) for full documentation.
#'
#' @param id &#91;required&#93; The group's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_run_group
omics_get_run_group <- function(id) {
  op <- new_operation(
    name = "GetRunGroup",
    http_method = "GET",
    http_path = "/runGroup/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$get_run_group_input(id = id)
  output <- .omics$get_run_group_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_run_group <- omics_get_run_group

#' Gets information about a workflow run task
#'
#' @description
#' Gets information about a workflow run task.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_run_task/](https://www.paws-r-sdk.com/docs/omics_get_run_task/) for full documentation.
#'
#' @param id &#91;required&#93; The workflow run ID.
#' @param taskId &#91;required&#93; The task's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_run_task
omics_get_run_task <- function(id, taskId) {
  op <- new_operation(
    name = "GetRunTask",
    http_method = "GET",
    http_path = "/run/{id}/task/{taskId}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$get_run_task_input(id = id, taskId = taskId)
  output <- .omics$get_run_task_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_run_task <- omics_get_run_task

#' Gets information about a sequence store
#'
#' @description
#' Gets information about a sequence store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_sequence_store/](https://www.paws-r-sdk.com/docs/omics_get_sequence_store/) for full documentation.
#'
#' @param id &#91;required&#93; The store's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_sequence_store
omics_get_sequence_store <- function(id) {
  op <- new_operation(
    name = "GetSequenceStore",
    http_method = "GET",
    http_path = "/sequencestore/{id}",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$get_sequence_store_input(id = id)
  output <- .omics$get_sequence_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_sequence_store <- omics_get_sequence_store

#' Retrieves the metadata for the specified resource share
#'
#' @description
#' Retrieves the metadata for the specified resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_share/](https://www.paws-r-sdk.com/docs/omics_get_share/) for full documentation.
#'
#' @param shareId &#91;required&#93; The ID of the share.
#'
#' @keywords internal
#'
#' @rdname omics_get_share
omics_get_share <- function(shareId) {
  op <- new_operation(
    name = "GetShare",
    http_method = "GET",
    http_path = "/share/{shareId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_share_input(shareId = shareId)
  output <- .omics$get_share_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_share <- omics_get_share

#' Gets information about a variant import job
#'
#' @description
#' Gets information about a variant import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_variant_import_job/](https://www.paws-r-sdk.com/docs/omics_get_variant_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname omics_get_variant_import_job
omics_get_variant_import_job <- function(jobId) {
  op <- new_operation(
    name = "GetVariantImportJob",
    http_method = "GET",
    http_path = "/import/variant/{jobId}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_variant_import_job_input(jobId = jobId)
  output <- .omics$get_variant_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_variant_import_job <- omics_get_variant_import_job

#' Gets information about a variant store
#'
#' @description
#' Gets information about a variant store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_variant_store/](https://www.paws-r-sdk.com/docs/omics_get_variant_store/) for full documentation.
#'
#' @param name &#91;required&#93; The store's name.
#'
#' @keywords internal
#'
#' @rdname omics_get_variant_store
omics_get_variant_store <- function(name) {
  op <- new_operation(
    name = "GetVariantStore",
    http_method = "GET",
    http_path = "/variantStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$get_variant_store_input(name = name)
  output <- .omics$get_variant_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_variant_store <- omics_get_variant_store

#' Gets information about a workflow
#'
#' @description
#' Gets information about a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_get_workflow/](https://www.paws-r-sdk.com/docs/omics_get_workflow/) for full documentation.
#'
#' @param id &#91;required&#93; The workflow's ID.
#' @param type The workflow's type.
#' @param export The export format for the workflow.
#' @param workflowOwnerId The ID of the workflow owner.
#'
#' @keywords internal
#'
#' @rdname omics_get_workflow
omics_get_workflow <- function(id, type = NULL, export = NULL, workflowOwnerId = NULL) {
  op <- new_operation(
    name = "GetWorkflow",
    http_method = "GET",
    http_path = "/workflow/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$get_workflow_input(id = id, type = type, export = export, workflowOwnerId = workflowOwnerId)
  output <- .omics$get_workflow_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$get_workflow <- omics_get_workflow

#' Retrieves a list of annotation import jobs
#'
#' @description
#' Retrieves a list of annotation import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_annotation_import_jobs/](https://www.paws-r-sdk.com/docs/omics_list_annotation_import_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of jobs to return in one page of results.
#' @param ids IDs of annotation import jobs to retrieve.
#' @param nextToken Specifies the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_annotation_import_jobs
omics_list_annotation_import_jobs <- function(maxResults = NULL, ids = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListAnnotationImportJobs",
    http_method = "POST",
    http_path = "/import/annotations",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "annotationImportJobs")
  )
  input <- .omics$list_annotation_import_jobs_input(maxResults = maxResults, ids = ids, nextToken = nextToken, filter = filter)
  output <- .omics$list_annotation_import_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_annotation_import_jobs <- omics_list_annotation_import_jobs

#' Lists the versions of an annotation store
#'
#' @description
#' Lists the versions of an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_annotation_store_versions/](https://www.paws-r-sdk.com/docs/omics_list_annotation_store_versions/) for full documentation.
#'
#' @param name &#91;required&#93; The name of an annotation store.
#' @param maxResults The maximum number of annotation store versions to return in one page of
#' results.
#' @param nextToken Specifies the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list of annotation store versions.
#'
#' @keywords internal
#'
#' @rdname omics_list_annotation_store_versions
omics_list_annotation_store_versions <- function(name, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListAnnotationStoreVersions",
    http_method = "POST",
    http_path = "/annotationStore/{name}/versions",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "annotationStoreVersions")
  )
  input <- .omics$list_annotation_store_versions_input(name = name, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_annotation_store_versions_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_annotation_store_versions <- omics_list_annotation_store_versions

#' Retrieves a list of annotation stores
#'
#' @description
#' Retrieves a list of annotation stores.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_annotation_stores/](https://www.paws-r-sdk.com/docs/omics_list_annotation_stores/) for full documentation.
#'
#' @param ids IDs of stores to list.
#' @param maxResults The maximum number of stores to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_annotation_stores
omics_list_annotation_stores <- function(ids = NULL, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListAnnotationStores",
    http_method = "POST",
    http_path = "/annotationStores",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "annotationStores")
  )
  input <- .omics$list_annotation_stores_input(ids = ids, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_annotation_stores_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_annotation_stores <- omics_list_annotation_stores

#' Lists multipart read set uploads and for in progress uploads
#'
#' @description
#' Lists multipart read set uploads and for in progress uploads. Once the upload is completed, a read set is created and the upload will no longer be returned in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_multipart_read_set_uploads/](https://www.paws-r-sdk.com/docs/omics_list_multipart_read_set_uploads/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The Sequence Store ID used for the multipart uploads.
#' @param maxResults The maximum number of multipart uploads returned in a page.
#' @param nextToken Next token returned in the response of a previous
#' ListMultipartReadSetUploads call. Used to get the next page of results.
#'
#' @keywords internal
#'
#' @rdname omics_list_multipart_read_set_uploads
omics_list_multipart_read_set_uploads <- function(sequenceStoreId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListMultipartReadSetUploads",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/uploads",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "uploads")
  )
  input <- .omics$list_multipart_read_set_uploads_input(sequenceStoreId = sequenceStoreId, maxResults = maxResults, nextToken = nextToken)
  output <- .omics$list_multipart_read_set_uploads_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_multipart_read_set_uploads <- omics_list_multipart_read_set_uploads

#' Retrieves a list of read set activation jobs
#'
#' @description
#' Retrieves a list of read set activation jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_read_set_activation_jobs/](https://www.paws-r-sdk.com/docs/omics_list_read_set_activation_jobs/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#' @param maxResults The maximum number of read set activation jobs to return in one page of
#' results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_read_set_activation_jobs
omics_list_read_set_activation_jobs <- function(sequenceStoreId, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReadSetActivationJobs",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/activationjobs",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "activationJobs")
  )
  input <- .omics$list_read_set_activation_jobs_input(sequenceStoreId = sequenceStoreId, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_read_set_activation_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_read_set_activation_jobs <- omics_list_read_set_activation_jobs

#' Retrieves a list of read set export jobs
#'
#' @description
#' Retrieves a list of read set export jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_read_set_export_jobs/](https://www.paws-r-sdk.com/docs/omics_list_read_set_export_jobs/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The jobs' sequence store ID.
#' @param maxResults The maximum number of jobs to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_read_set_export_jobs
omics_list_read_set_export_jobs <- function(sequenceStoreId, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReadSetExportJobs",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/exportjobs",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "exportJobs")
  )
  input <- .omics$list_read_set_export_jobs_input(sequenceStoreId = sequenceStoreId, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_read_set_export_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_read_set_export_jobs <- omics_list_read_set_export_jobs

#' Retrieves a list of read set import jobs
#'
#' @description
#' Retrieves a list of read set import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_read_set_import_jobs/](https://www.paws-r-sdk.com/docs/omics_list_read_set_import_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of jobs to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param sequenceStoreId &#91;required&#93; The jobs' sequence store ID.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_read_set_import_jobs
omics_list_read_set_import_jobs <- function(maxResults = NULL, nextToken = NULL, sequenceStoreId, filter = NULL) {
  op <- new_operation(
    name = "ListReadSetImportJobs",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/importjobs",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "importJobs")
  )
  input <- .omics$list_read_set_import_jobs_input(maxResults = maxResults, nextToken = nextToken, sequenceStoreId = sequenceStoreId, filter = filter)
  output <- .omics$list_read_set_import_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_read_set_import_jobs <- omics_list_read_set_import_jobs

#' This operation will list all parts in a requested multipart upload for a
#' sequence store
#'
#' @description
#' This operation will list all parts in a requested multipart upload for a sequence store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_read_set_upload_parts/](https://www.paws-r-sdk.com/docs/omics_list_read_set_upload_parts/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The Sequence Store ID used for the multipart uploads.
#' @param uploadId &#91;required&#93; The ID for the initiated multipart upload.
#' @param partSource &#91;required&#93; The source file for the upload part.
#' @param maxResults The maximum number of read set upload parts returned in a page.
#' @param nextToken Next token returned in the response of a previous
#' ListReadSetUploadPartsRequest call. Used to get the next page of
#' results.
#' @param filter Attributes used to filter for a specific subset of read set part
#' uploads.
#'
#' @keywords internal
#'
#' @rdname omics_list_read_set_upload_parts
omics_list_read_set_upload_parts <- function(sequenceStoreId, uploadId, partSource, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReadSetUploadParts",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/upload/{uploadId}/parts",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "parts")
  )
  input <- .omics$list_read_set_upload_parts_input(sequenceStoreId = sequenceStoreId, uploadId = uploadId, partSource = partSource, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_read_set_upload_parts_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_read_set_upload_parts <- omics_list_read_set_upload_parts

#' Retrieves a list of read sets
#'
#' @description
#' Retrieves a list of read sets.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_read_sets/](https://www.paws-r-sdk.com/docs/omics_list_read_sets/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The jobs' sequence store ID.
#' @param maxResults The maximum number of read sets to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_read_sets
omics_list_read_sets <- function(sequenceStoreId, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReadSets",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/readsets",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "readSets")
  )
  input <- .omics$list_read_sets_input(sequenceStoreId = sequenceStoreId, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_read_sets_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_read_sets <- omics_list_read_sets

#' Retrieves a list of reference import jobs
#'
#' @description
#' Retrieves a list of reference import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_reference_import_jobs/](https://www.paws-r-sdk.com/docs/omics_list_reference_import_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of jobs to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param referenceStoreId &#91;required&#93; The job's reference store ID.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_reference_import_jobs
omics_list_reference_import_jobs <- function(maxResults = NULL, nextToken = NULL, referenceStoreId, filter = NULL) {
  op <- new_operation(
    name = "ListReferenceImportJobs",
    http_method = "POST",
    http_path = "/referencestore/{referenceStoreId}/importjobs",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "importJobs")
  )
  input <- .omics$list_reference_import_jobs_input(maxResults = maxResults, nextToken = nextToken, referenceStoreId = referenceStoreId, filter = filter)
  output <- .omics$list_reference_import_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_reference_import_jobs <- omics_list_reference_import_jobs

#' Retrieves a list of reference stores
#'
#' @description
#' Retrieves a list of reference stores.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_reference_stores/](https://www.paws-r-sdk.com/docs/omics_list_reference_stores/) for full documentation.
#'
#' @param maxResults The maximum number of stores to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_reference_stores
omics_list_reference_stores <- function(maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReferenceStores",
    http_method = "POST",
    http_path = "/referencestores",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "referenceStores")
  )
  input <- .omics$list_reference_stores_input(maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_reference_stores_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_reference_stores <- omics_list_reference_stores

#' Retrieves a list of references
#'
#' @description
#' Retrieves a list of references.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_references/](https://www.paws-r-sdk.com/docs/omics_list_references/) for full documentation.
#'
#' @param referenceStoreId &#91;required&#93; The references' reference store ID.
#' @param maxResults The maximum number of references to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_references
omics_list_references <- function(referenceStoreId, maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReferences",
    http_method = "POST",
    http_path = "/referencestore/{referenceStoreId}/references",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "references")
  )
  input <- .omics$list_references_input(referenceStoreId = referenceStoreId, maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_references_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_references <- omics_list_references

#' Retrieves a list of run groups
#'
#' @description
#' Retrieves a list of run groups.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_run_groups/](https://www.paws-r-sdk.com/docs/omics_list_run_groups/) for full documentation.
#'
#' @param name The run groups' name.
#' @param startingToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of run groups to return in one page of results.
#'
#' @keywords internal
#'
#' @rdname omics_list_run_groups
omics_list_run_groups <- function(name = NULL, startingToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRunGroups",
    http_method = "GET",
    http_path = "/runGroup",
    host_prefix = "workflows-",
    paginator = list(input_token = "startingToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .omics$list_run_groups_input(name = name, startingToken = startingToken, maxResults = maxResults)
  output <- .omics$list_run_groups_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_run_groups <- omics_list_run_groups

#' Retrieves a list of tasks for a run
#'
#' @description
#' Retrieves a list of tasks for a run.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_run_tasks/](https://www.paws-r-sdk.com/docs/omics_list_run_tasks/) for full documentation.
#'
#' @param id &#91;required&#93; The run's ID.
#' @param status Filter the list by status.
#' @param startingToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of run tasks to return in one page of results.
#'
#' @keywords internal
#'
#' @rdname omics_list_run_tasks
omics_list_run_tasks <- function(id, status = NULL, startingToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRunTasks",
    http_method = "GET",
    http_path = "/run/{id}/task",
    host_prefix = "workflows-",
    paginator = list(input_token = "startingToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .omics$list_run_tasks_input(id = id, status = status, startingToken = startingToken, maxResults = maxResults)
  output <- .omics$list_run_tasks_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_run_tasks <- omics_list_run_tasks

#' Retrieves a list of runs
#'
#' @description
#' Retrieves a list of runs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_runs/](https://www.paws-r-sdk.com/docs/omics_list_runs/) for full documentation.
#'
#' @param name Filter the list by run name.
#' @param runGroupId Filter the list by run group ID.
#' @param startingToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of runs to return in one page of results.
#' @param status The status of a run.
#'
#' @keywords internal
#'
#' @rdname omics_list_runs
omics_list_runs <- function(name = NULL, runGroupId = NULL, startingToken = NULL, maxResults = NULL, status = NULL) {
  op <- new_operation(
    name = "ListRuns",
    http_method = "GET",
    http_path = "/run",
    host_prefix = "workflows-",
    paginator = list(input_token = "startingToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .omics$list_runs_input(name = name, runGroupId = runGroupId, startingToken = startingToken, maxResults = maxResults, status = status)
  output <- .omics$list_runs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_runs <- omics_list_runs

#' Retrieves a list of sequence stores
#'
#' @description
#' Retrieves a list of sequence stores.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_sequence_stores/](https://www.paws-r-sdk.com/docs/omics_list_sequence_stores/) for full documentation.
#'
#' @param maxResults The maximum number of stores to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_sequence_stores
omics_list_sequence_stores <- function(maxResults = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListSequenceStores",
    http_method = "POST",
    http_path = "/sequencestores",
    host_prefix = "control-storage-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "sequenceStores")
  )
  input <- .omics$list_sequence_stores_input(maxResults = maxResults, nextToken = nextToken, filter = filter)
  output <- .omics$list_sequence_stores_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_sequence_stores <- omics_list_sequence_stores

#' Retrieves the resource shares associated with an account
#'
#' @description
#' Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset of the shares.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_shares/](https://www.paws-r-sdk.com/docs/omics_list_shares/) for full documentation.
#'
#' @param resourceOwner &#91;required&#93; The account that owns the resource shares.
#' @param filter Attributes that you use to filter for a specific subset of resource
#' shares.
#' @param nextToken Next token returned in the response of a previous
#' ListReadSetUploadPartsRequest call. Used to get the next page of
#' results.
#' @param maxResults The maximum number of shares to return in one page of results.
#'
#' @keywords internal
#'
#' @rdname omics_list_shares
omics_list_shares <- function(resourceOwner, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListShares",
    http_method = "POST",
    http_path = "/shares",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "shares")
  )
  input <- .omics$list_shares_input(resourceOwner = resourceOwner, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .omics$list_shares_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_shares <- omics_list_shares

#' Retrieves a list of tags for a resource
#'
#' @description
#' Retrieves a list of tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/omics_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's ARN.
#'
#' @keywords internal
#'
#' @rdname omics_list_tags_for_resource
omics_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "tags-",
    paginator = list()
  )
  input <- .omics$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .omics$list_tags_for_resource_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_tags_for_resource <- omics_list_tags_for_resource

#' Retrieves a list of variant import jobs
#'
#' @description
#' Retrieves a list of variant import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_variant_import_jobs/](https://www.paws-r-sdk.com/docs/omics_list_variant_import_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of import jobs to return in one page of results.
#' @param ids A list of job IDs.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_variant_import_jobs
omics_list_variant_import_jobs <- function(maxResults = NULL, ids = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListVariantImportJobs",
    http_method = "POST",
    http_path = "/import/variants",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "variantImportJobs")
  )
  input <- .omics$list_variant_import_jobs_input(maxResults = maxResults, ids = ids, nextToken = nextToken, filter = filter)
  output <- .omics$list_variant_import_jobs_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_variant_import_jobs <- omics_list_variant_import_jobs

#' Retrieves a list of variant stores
#'
#' @description
#' Retrieves a list of variant stores.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_variant_stores/](https://www.paws-r-sdk.com/docs/omics_list_variant_stores/) for full documentation.
#'
#' @param maxResults The maximum number of stores to return in one page of results.
#' @param ids A list of store IDs.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param filter A filter to apply to the list.
#'
#' @keywords internal
#'
#' @rdname omics_list_variant_stores
omics_list_variant_stores <- function(maxResults = NULL, ids = NULL, nextToken = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListVariantStores",
    http_method = "POST",
    http_path = "/variantStores",
    host_prefix = "analytics-",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "variantStores")
  )
  input <- .omics$list_variant_stores_input(maxResults = maxResults, ids = ids, nextToken = nextToken, filter = filter)
  output <- .omics$list_variant_stores_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_variant_stores <- omics_list_variant_stores

#' Retrieves a list of workflows
#'
#' @description
#' Retrieves a list of workflows.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_list_workflows/](https://www.paws-r-sdk.com/docs/omics_list_workflows/) for full documentation.
#'
#' @param type Filter the list by workflow type.
#' @param name Filter the list by workflow name.
#' @param startingToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of workflows to return in one page of results.
#'
#' @keywords internal
#'
#' @rdname omics_list_workflows
omics_list_workflows <- function(type = NULL, name = NULL, startingToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListWorkflows",
    http_method = "GET",
    http_path = "/workflow",
    host_prefix = "workflows-",
    paginator = list(input_token = "startingToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .omics$list_workflows_input(type = type, name = name, startingToken = startingToken, maxResults = maxResults)
  output <- .omics$list_workflows_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$list_workflows <- omics_list_workflows

#' Starts an annotation import job
#'
#' @description
#' Starts an annotation import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_annotation_import_job/](https://www.paws-r-sdk.com/docs/omics_start_annotation_import_job/) for full documentation.
#'
#' @param destinationName &#91;required&#93; A destination annotation store for the job.
#' @param roleArn &#91;required&#93; A service role for the job.
#' @param items &#91;required&#93; Items to import.
#' @param versionName The name of the annotation store version.
#' @param formatOptions Formatting options for the annotation file.
#' @param runLeftNormalization The job's left normalization setting.
#' @param annotationFields The annotation schema generated by the parsed annotation data.
#'
#' @keywords internal
#'
#' @rdname omics_start_annotation_import_job
omics_start_annotation_import_job <- function(destinationName, roleArn, items, versionName = NULL, formatOptions = NULL, runLeftNormalization = NULL, annotationFields = NULL) {
  op <- new_operation(
    name = "StartAnnotationImportJob",
    http_method = "POST",
    http_path = "/import/annotation",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$start_annotation_import_job_input(destinationName = destinationName, roleArn = roleArn, items = items, versionName = versionName, formatOptions = formatOptions, runLeftNormalization = runLeftNormalization, annotationFields = annotationFields)
  output <- .omics$start_annotation_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_annotation_import_job <- omics_start_annotation_import_job

#' Activates an archived read set
#'
#' @description
#' Activates an archived read set. To reduce storage charges, Amazon Omics archives unused read sets after 30 days.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_read_set_activation_job/](https://www.paws-r-sdk.com/docs/omics_start_read_set_activation_job/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#' @param clientToken To ensure that jobs don't run multiple times, specify a unique token for
#' each job.
#' @param sources &#91;required&#93; The job's source files.
#'
#' @keywords internal
#'
#' @rdname omics_start_read_set_activation_job
omics_start_read_set_activation_job <- function(sequenceStoreId, clientToken = NULL, sources) {
  op <- new_operation(
    name = "StartReadSetActivationJob",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/activationjob",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$start_read_set_activation_job_input(sequenceStoreId = sequenceStoreId, clientToken = clientToken, sources = sources)
  output <- .omics$start_read_set_activation_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_read_set_activation_job <- omics_start_read_set_activation_job

#' Exports a read set to Amazon S3
#'
#' @description
#' Exports a read set to Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_read_set_export_job/](https://www.paws-r-sdk.com/docs/omics_start_read_set_export_job/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#' @param destination &#91;required&#93; A location for exported files in Amazon S3.
#' @param roleArn &#91;required&#93; A service role for the job.
#' @param clientToken To ensure that jobs don't run multiple times, specify a unique token for
#' each job.
#' @param sources &#91;required&#93; The job's source files.
#'
#' @keywords internal
#'
#' @rdname omics_start_read_set_export_job
omics_start_read_set_export_job <- function(sequenceStoreId, destination, roleArn, clientToken = NULL, sources) {
  op <- new_operation(
    name = "StartReadSetExportJob",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/exportjob",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$start_read_set_export_job_input(sequenceStoreId = sequenceStoreId, destination = destination, roleArn = roleArn, clientToken = clientToken, sources = sources)
  output <- .omics$start_read_set_export_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_read_set_export_job <- omics_start_read_set_export_job

#' Starts a read set import job
#'
#' @description
#' Starts a read set import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_read_set_import_job/](https://www.paws-r-sdk.com/docs/omics_start_read_set_import_job/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The read set's sequence store ID.
#' @param roleArn &#91;required&#93; A service role for the job.
#' @param clientToken To ensure that jobs don't run multiple times, specify a unique token for
#' each job.
#' @param sources &#91;required&#93; The job's source files.
#'
#' @keywords internal
#'
#' @rdname omics_start_read_set_import_job
omics_start_read_set_import_job <- function(sequenceStoreId, roleArn, clientToken = NULL, sources) {
  op <- new_operation(
    name = "StartReadSetImportJob",
    http_method = "POST",
    http_path = "/sequencestore/{sequenceStoreId}/importjob",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$start_read_set_import_job_input(sequenceStoreId = sequenceStoreId, roleArn = roleArn, clientToken = clientToken, sources = sources)
  output <- .omics$start_read_set_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_read_set_import_job <- omics_start_read_set_import_job

#' Starts a reference import job
#'
#' @description
#' Starts a reference import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_reference_import_job/](https://www.paws-r-sdk.com/docs/omics_start_reference_import_job/) for full documentation.
#'
#' @param referenceStoreId &#91;required&#93; The job's reference store ID.
#' @param roleArn &#91;required&#93; A service role for the job.
#' @param clientToken To ensure that jobs don't run multiple times, specify a unique token for
#' each job.
#' @param sources &#91;required&#93; The job's source files.
#'
#' @keywords internal
#'
#' @rdname omics_start_reference_import_job
omics_start_reference_import_job <- function(referenceStoreId, roleArn, clientToken = NULL, sources) {
  op <- new_operation(
    name = "StartReferenceImportJob",
    http_method = "POST",
    http_path = "/referencestore/{referenceStoreId}/importjob",
    host_prefix = "control-storage-",
    paginator = list()
  )
  input <- .omics$start_reference_import_job_input(referenceStoreId = referenceStoreId, roleArn = roleArn, clientToken = clientToken, sources = sources)
  output <- .omics$start_reference_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_reference_import_job <- omics_start_reference_import_job

#' Starts a workflow run
#'
#' @description
#' Starts a workflow run. To duplicate a run, specify the run's ID and a role ARN. The remaining parameters are copied from the previous run.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_run/](https://www.paws-r-sdk.com/docs/omics_start_run/) for full documentation.
#'
#' @param workflowId The run's workflow ID.
#' @param workflowType The run's workflow type.
#' @param runId The ID of a run to duplicate.
#' @param roleArn &#91;required&#93; A service role for the run.
#' @param name A name for the run.
#' @param runGroupId The run's group ID.
#' @param priority A priority for the run.
#' @param parameters Parameters for the run.
#' @param storageCapacity A storage capacity for the run in gibibytes. This field is not required
#' if the storage type is dynamic (the system ignores any value that you
#' enter).
#' @param outputUri An output URI for the run.
#' @param logLevel A log level for the run.
#' @param tags Tags for the run.
#' @param requestId &#91;required&#93; To ensure that requests don't run multiple times, specify a unique ID
#' for each request.
#' @param retentionMode The retention mode for the run.
#' @param storageType The run's storage type. By default, the run uses STATIC storage type,
#' which allocates a fixed amount of storage. If you set the storage type
#' to DYNAMIC, HealthOmics dynamically scales the storage up or down, based
#' on file system utilization.
#' @param workflowOwnerId The ID of the workflow owner.
#'
#' @keywords internal
#'
#' @rdname omics_start_run
omics_start_run <- function(workflowId = NULL, workflowType = NULL, runId = NULL, roleArn, name = NULL, runGroupId = NULL, priority = NULL, parameters = NULL, storageCapacity = NULL, outputUri = NULL, logLevel = NULL, tags = NULL, requestId, retentionMode = NULL, storageType = NULL, workflowOwnerId = NULL) {
  op <- new_operation(
    name = "StartRun",
    http_method = "POST",
    http_path = "/run",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$start_run_input(workflowId = workflowId, workflowType = workflowType, runId = runId, roleArn = roleArn, name = name, runGroupId = runGroupId, priority = priority, parameters = parameters, storageCapacity = storageCapacity, outputUri = outputUri, logLevel = logLevel, tags = tags, requestId = requestId, retentionMode = retentionMode, storageType = storageType, workflowOwnerId = workflowOwnerId)
  output <- .omics$start_run_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_run <- omics_start_run

#' Starts a variant import job
#'
#' @description
#' Starts a variant import job.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_start_variant_import_job/](https://www.paws-r-sdk.com/docs/omics_start_variant_import_job/) for full documentation.
#'
#' @param destinationName &#91;required&#93; The destination variant store for the job.
#' @param roleArn &#91;required&#93; A service role for the job.
#' @param items &#91;required&#93; Items to import.
#' @param runLeftNormalization The job's left normalization setting.
#' @param annotationFields The annotation schema generated by the parsed annotation data.
#'
#' @keywords internal
#'
#' @rdname omics_start_variant_import_job
omics_start_variant_import_job <- function(destinationName, roleArn, items, runLeftNormalization = NULL, annotationFields = NULL) {
  op <- new_operation(
    name = "StartVariantImportJob",
    http_method = "POST",
    http_path = "/import/variant",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$start_variant_import_job_input(destinationName = destinationName, roleArn = roleArn, items = items, runLeftNormalization = runLeftNormalization, annotationFields = annotationFields)
  output <- .omics$start_variant_import_job_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$start_variant_import_job <- omics_start_variant_import_job

#' Tags a resource
#'
#' @description
#' Tags a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_tag_resource/](https://www.paws-r-sdk.com/docs/omics_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's ARN.
#' @param tags &#91;required&#93; Tags for the resource.
#'
#' @keywords internal
#'
#' @rdname omics_tag_resource
omics_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "tags-",
    paginator = list()
  )
  input <- .omics$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .omics$tag_resource_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$tag_resource <- omics_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_untag_resource/](https://www.paws-r-sdk.com/docs/omics_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's ARN.
#' @param tagKeys &#91;required&#93; Keys of tags to remove.
#'
#' @keywords internal
#'
#' @rdname omics_untag_resource
omics_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "tags-",
    paginator = list()
  )
  input <- .omics$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .omics$untag_resource_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$untag_resource <- omics_untag_resource

#' Updates an annotation store
#'
#' @description
#' Updates an annotation store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_update_annotation_store/](https://www.paws-r-sdk.com/docs/omics_update_annotation_store/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the store.
#' @param description A description for the store.
#'
#' @keywords internal
#'
#' @rdname omics_update_annotation_store
omics_update_annotation_store <- function(name, description = NULL) {
  op <- new_operation(
    name = "UpdateAnnotationStore",
    http_method = "POST",
    http_path = "/annotationStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$update_annotation_store_input(name = name, description = description)
  output <- .omics$update_annotation_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$update_annotation_store <- omics_update_annotation_store

#' Updates the description of an annotation store version
#'
#' @description
#' Updates the description of an annotation store version.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_update_annotation_store_version/](https://www.paws-r-sdk.com/docs/omics_update_annotation_store_version/) for full documentation.
#'
#' @param name &#91;required&#93; The name of an annotation store.
#' @param versionName &#91;required&#93; The name of an annotation store version.
#' @param description The description of an annotation store.
#'
#' @keywords internal
#'
#' @rdname omics_update_annotation_store_version
omics_update_annotation_store_version <- function(name, versionName, description = NULL) {
  op <- new_operation(
    name = "UpdateAnnotationStoreVersion",
    http_method = "POST",
    http_path = "/annotationStore/{name}/version/{versionName}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$update_annotation_store_version_input(name = name, versionName = versionName, description = description)
  output <- .omics$update_annotation_store_version_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$update_annotation_store_version <- omics_update_annotation_store_version

#' Updates a run group
#'
#' @description
#' Updates a run group.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_update_run_group/](https://www.paws-r-sdk.com/docs/omics_update_run_group/) for full documentation.
#'
#' @param id &#91;required&#93; The group's ID.
#' @param name A name for the group.
#' @param maxCpus The maximum number of CPUs to use.
#' @param maxRuns The maximum number of concurrent runs for the group.
#' @param maxDuration A maximum run time for the group in minutes.
#' @param maxGpus The maximum GPUs that can be used by a run group.
#'
#' @keywords internal
#'
#' @rdname omics_update_run_group
omics_update_run_group <- function(id, name = NULL, maxCpus = NULL, maxRuns = NULL, maxDuration = NULL, maxGpus = NULL) {
  op <- new_operation(
    name = "UpdateRunGroup",
    http_method = "POST",
    http_path = "/runGroup/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$update_run_group_input(id = id, name = name, maxCpus = maxCpus, maxRuns = maxRuns, maxDuration = maxDuration, maxGpus = maxGpus)
  output <- .omics$update_run_group_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$update_run_group <- omics_update_run_group

#' Updates a variant store
#'
#' @description
#' Updates a variant store.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_update_variant_store/](https://www.paws-r-sdk.com/docs/omics_update_variant_store/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the store.
#' @param description A description for the store.
#'
#' @keywords internal
#'
#' @rdname omics_update_variant_store
omics_update_variant_store <- function(name, description = NULL) {
  op <- new_operation(
    name = "UpdateVariantStore",
    http_method = "POST",
    http_path = "/variantStore/{name}",
    host_prefix = "analytics-",
    paginator = list()
  )
  input <- .omics$update_variant_store_input(name = name, description = description)
  output <- .omics$update_variant_store_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$update_variant_store <- omics_update_variant_store

#' Updates a workflow
#'
#' @description
#' Updates a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_update_workflow/](https://www.paws-r-sdk.com/docs/omics_update_workflow/) for full documentation.
#'
#' @param id &#91;required&#93; The workflow's ID.
#' @param name A name for the workflow.
#' @param description A description for the workflow.
#'
#' @keywords internal
#'
#' @rdname omics_update_workflow
omics_update_workflow <- function(id, name = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateWorkflow",
    http_method = "POST",
    http_path = "/workflow/{id}",
    host_prefix = "workflows-",
    paginator = list()
  )
  input <- .omics$update_workflow_input(id = id, name = name, description = description)
  output <- .omics$update_workflow_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$update_workflow <- omics_update_workflow

#' This operation uploads a specific part of a read set
#'
#' @description
#' This operation uploads a specific part of a read set. If you upload a new part using a previously used part number, the previously uploaded part will be overwritten.
#'
#' See [https://www.paws-r-sdk.com/docs/omics_upload_read_set_part/](https://www.paws-r-sdk.com/docs/omics_upload_read_set_part/) for full documentation.
#'
#' @param sequenceStoreId &#91;required&#93; The Sequence Store ID used for the multipart upload.
#' @param uploadId &#91;required&#93; The ID for the initiated multipart upload.
#' @param partSource &#91;required&#93; The source file for an upload part.
#' @param partNumber &#91;required&#93; The number of the part being uploaded.
#' @param payload &#91;required&#93; The read set data to upload for a part.
#'
#' @keywords internal
#'
#' @rdname omics_upload_read_set_part
omics_upload_read_set_part <- function(sequenceStoreId, uploadId, partSource, partNumber, payload) {
  op <- new_operation(
    name = "UploadReadSetPart",
    http_method = "PUT",
    http_path = "/sequencestore/{sequenceStoreId}/upload/{uploadId}/part",
    host_prefix = "storage-",
    paginator = list()
  )
  input <- .omics$upload_read_set_part_input(sequenceStoreId = sequenceStoreId, uploadId = uploadId, partSource = partSource, partNumber = partNumber, payload = payload)
  output <- .omics$upload_read_set_part_output()
  config <- get_config()
  svc <- .omics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.omics$operations$upload_read_set_part <- omics_upload_read_set_part
