# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include dlm_service.R
NULL

#' Creates a policy to manage the lifecycle of the specified Amazon Web
#' Services resources
#'
#' @description
#' Creates a policy to manage the lifecycle of the specified Amazon Web Services resources. You can create up to 100 lifecycle policies.
#'
#' See [https://paws-r.github.io/docs/dlm/create_lifecycle_policy.html](https://paws-r.github.io/docs/dlm/create_lifecycle_policy.html) for full documentation.
#'
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role used to run the
#' operations specified by the lifecycle policy.
#' @param Description &#91;required&#93; A description of the lifecycle policy. The characters ^\[0-9A-Za-z
#' _-\]+$ are supported.
#' @param State &#91;required&#93; The desired activation state of the lifecycle policy after creation.
#' @param PolicyDetails &#91;required&#93; The configuration details of the lifecycle policy.
#' @param Tags The tags to apply to the lifecycle policy during creation.
#'
#' @keywords internal
#'
#' @rdname dlm_create_lifecycle_policy
dlm_create_lifecycle_policy <- function(ExecutionRoleArn, Description, State, PolicyDetails, Tags = NULL) {
  op <- new_operation(
    name = "CreateLifecyclePolicy",
    http_method = "POST",
    http_path = "/policies",
    paginator = list()
  )
  input <- .dlm$create_lifecycle_policy_input(ExecutionRoleArn = ExecutionRoleArn, Description = Description, State = State, PolicyDetails = PolicyDetails, Tags = Tags)
  output <- .dlm$create_lifecycle_policy_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$create_lifecycle_policy <- dlm_create_lifecycle_policy

#' Deletes the specified lifecycle policy and halts the automated
#' operations that the policy specified
#'
#' @description
#' Deletes the specified lifecycle policy and halts the automated operations that the policy specified.
#'
#' See [https://paws-r.github.io/docs/dlm/delete_lifecycle_policy.html](https://paws-r.github.io/docs/dlm/delete_lifecycle_policy.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname dlm_delete_lifecycle_policy
dlm_delete_lifecycle_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DeleteLifecyclePolicy",
    http_method = "DELETE",
    http_path = "/policies/{policyId}/",
    paginator = list()
  )
  input <- .dlm$delete_lifecycle_policy_input(PolicyId = PolicyId)
  output <- .dlm$delete_lifecycle_policy_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$delete_lifecycle_policy <- dlm_delete_lifecycle_policy

#' Gets summary information about all or the specified data lifecycle
#' policies
#'
#' @description
#' Gets summary information about all or the specified data lifecycle policies.
#'
#' See [https://paws-r.github.io/docs/dlm/get_lifecycle_policies.html](https://paws-r.github.io/docs/dlm/get_lifecycle_policies.html) for full documentation.
#'
#' @param PolicyIds The identifiers of the data lifecycle policies.
#' @param State The activation state.
#' @param ResourceTypes The resource type.
#' @param TargetTags The target tag for a policy.
#' 
#' Tags are strings in the format `key=value`.
#' @param TagsToAdd The tags to add to objects created by the policy.
#' 
#' Tags are strings in the format `key=value`.
#' 
#' These user-defined tags are added in addition to the Amazon Web
#' Services-added lifecycle tags.
#'
#' @keywords internal
#'
#' @rdname dlm_get_lifecycle_policies
dlm_get_lifecycle_policies <- function(PolicyIds = NULL, State = NULL, ResourceTypes = NULL, TargetTags = NULL, TagsToAdd = NULL) {
  op <- new_operation(
    name = "GetLifecyclePolicies",
    http_method = "GET",
    http_path = "/policies",
    paginator = list()
  )
  input <- .dlm$get_lifecycle_policies_input(PolicyIds = PolicyIds, State = State, ResourceTypes = ResourceTypes, TargetTags = TargetTags, TagsToAdd = TagsToAdd)
  output <- .dlm$get_lifecycle_policies_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$get_lifecycle_policies <- dlm_get_lifecycle_policies

#' Gets detailed information about the specified lifecycle policy
#'
#' @description
#' Gets detailed information about the specified lifecycle policy.
#'
#' See [https://paws-r.github.io/docs/dlm/get_lifecycle_policy.html](https://paws-r.github.io/docs/dlm/get_lifecycle_policy.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname dlm_get_lifecycle_policy
dlm_get_lifecycle_policy <- function(PolicyId) {
  op <- new_operation(
    name = "GetLifecyclePolicy",
    http_method = "GET",
    http_path = "/policies/{policyId}/",
    paginator = list()
  )
  input <- .dlm$get_lifecycle_policy_input(PolicyId = PolicyId)
  output <- .dlm$get_lifecycle_policy_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$get_lifecycle_policy <- dlm_get_lifecycle_policy

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://paws-r.github.io/docs/dlm/list_tags_for_resource.html](https://paws-r.github.io/docs/dlm/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname dlm_list_tags_for_resource
dlm_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .dlm$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .dlm$list_tags_for_resource_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$list_tags_for_resource <- dlm_list_tags_for_resource

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource.
#'
#' See [https://paws-r.github.io/docs/dlm/tag_resource.html](https://paws-r.github.io/docs/dlm/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @keywords internal
#'
#' @rdname dlm_tag_resource
dlm_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .dlm$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .dlm$tag_resource_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$tag_resource <- dlm_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://paws-r.github.io/docs/dlm/untag_resource.html](https://paws-r.github.io/docs/dlm/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname dlm_untag_resource
dlm_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .dlm$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .dlm$untag_resource_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$untag_resource <- dlm_untag_resource

#' Updates the specified lifecycle policy
#'
#' @description
#' Updates the specified lifecycle policy.
#'
#' See [https://paws-r.github.io/docs/dlm/update_lifecycle_policy.html](https://paws-r.github.io/docs/dlm/update_lifecycle_policy.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the
#' operations specified by the lifecycle policy.
#' @param State The desired activation state of the lifecycle policy after creation.
#' @param Description A description of the lifecycle policy.
#' @param PolicyDetails The configuration of the lifecycle policy. You cannot update the policy
#' type or the resource type.
#'
#' @keywords internal
#'
#' @rdname dlm_update_lifecycle_policy
dlm_update_lifecycle_policy <- function(PolicyId, ExecutionRoleArn = NULL, State = NULL, Description = NULL, PolicyDetails = NULL) {
  op <- new_operation(
    name = "UpdateLifecyclePolicy",
    http_method = "PATCH",
    http_path = "/policies/{policyId}",
    paginator = list()
  )
  input <- .dlm$update_lifecycle_policy_input(PolicyId = PolicyId, ExecutionRoleArn = ExecutionRoleArn, State = State, Description = Description, PolicyDetails = PolicyDetails)
  output <- .dlm$update_lifecycle_policy_output()
  config <- get_config()
  svc <- .dlm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$update_lifecycle_policy <- dlm_update_lifecycle_policy
