% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_remove_tags_from_vault}
\alias{glacier_remove_tags_from_vault}
\title{This operation removes one or more tags from the set of tags attached to
a vault}
\usage{
glacier_remove_tags_from_vault(accountId, vaultName, TagKeys)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
\'\code{-}\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{TagKeys}{A list of tag keys. Each corresponding tag is removed from the vault.}
}
\description{
This operation removes one or more tags from the set of tags attached to
a vault. For more information about tags, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html}{Tagging Amazon S3 Glacier Resources}.
This operation is idempotent. The operation will be successful, even if
there are no tags attached to the vault.
}
\section{Request syntax}{
\preformatted{svc$remove_tags_from_vault(
  accountId = "string",
  vaultName = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The example removes two tags from the vault named examplevault.
svc$remove_tags_from_vault(
  TagKeys = list(
    "examplekey1",
    "examplekey2"
  ),
  accountId = "-",
  vaultName = "examplevault"
)
}

}
\keyword{internal}
