% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_put_bucket_lifecycle_configuration}
\alias{s3control_put_bucket_lifecycle_configuration}
\title{This action puts a lifecycle configuration to an Amazon S3 on Outposts
bucket}
\usage{
s3control_put_bucket_lifecycle_configuration(AccountId, Bucket,
  LifecycleConfiguration)
}
\arguments{
\item{AccountId}{[required] The AWS account ID of the Outposts bucket.}

\item{Bucket}{[required] The name of the bucket for which to set the configuration.}

\item{LifecycleConfiguration}{Container for lifecycle rules. You can add as many as 1,000 rules.}
}
\description{
This action puts a lifecycle configuration to an Amazon S3 on Outposts
bucket. To put a lifecycle configuration to an S3 bucket, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html}{PutBucketLifecycleConfiguration}
in the \emph{Amazon Simple Storage Service API}.

Creates a new lifecycle configuration for the Outposts bucket or
replaces an existing lifecycle configuration. Outposts buckets only
support lifecycle configurations that delete/expire objects after a
certain period of time and abort incomplete multipart uploads. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html}{Managing Lifecycle Permissions for Amazon S3 on Outposts}.

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples}{Examples}
section.

The following actions are related to \code{PutBucketLifecycleConfiguration}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html}{GetBucketLifecycleConfiguration}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html}{DeleteBucketLifecycleConfiguration}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_lifecycle_configuration(
  AccountId = "string",
  Bucket = "string",
  LifecycleConfiguration = list(
    Rules = list(
      list(
        Expiration = list(
          Date = as.POSIXct(
            "2015-01-01"
          ),
          Days = 123,
          ExpiredObjectDeleteMarker = TRUE|FALSE
        ),
        ID = "string",
        Filter = list(
          Prefix = "string",
          Tag = list(
            Key = "string",
            Value = "string"
          ),
          And = list(
            Prefix = "string",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        ),
        Status = "Enabled"|"Disabled",
        Transitions = list(
          list(
            Date = as.POSIXct(
              "2015-01-01"
            ),
            Days = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionTransitions = list(
          list(
            NoncurrentDays = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionExpiration = list(
          NoncurrentDays = 123
        ),
        AbortIncompleteMultipartUpload = list(
          DaysAfterInitiation = 123
        )
      )
    )
  )
)
}
}

\keyword{internal}
