# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include s3control_service.R
NULL

#' Removes the Public Access Block configuration for an Amazon Web Services
#' account
#'
#' Removes the Public Access Block configuration for an Amazon Web Services
#' account.
#'
#' @usage
#' s3control_delete_public_access_block(AccountId)
#'
#' @param AccountId &#91;required&#93; The Account ID for the Amazon Web Services account whose Public Access
#' Block configuration you want to remove.
#'
#' @section Request syntax:
#' ```
#' svc$delete_public_access_block(
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_delete_public_access_block
s3control_delete_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$delete_public_access_block_input(AccountId = AccountId)
  output <- .s3control$delete_public_access_block_output()
  svc <- .s3control$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_public_access_block <- s3control_delete_public_access_block

#' Retrieves the Public Access Block configuration for an Amazon Web
#' Services account
#'
#' Retrieves the Public Access Block configuration for an Amazon Web
#' Services account.
#'
#' @usage
#' s3control_get_public_access_block(AccountId)
#'
#' @param AccountId &#91;required&#93; The Account ID for the Amazon Web Services account whose Public Access
#' Block configuration you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_access_block(
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_get_public_access_block
s3control_get_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$get_public_access_block_input(AccountId = AccountId)
  output <- .s3control$get_public_access_block_output()
  svc <- .s3control$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_public_access_block <- s3control_get_public_access_block

#' Creates or modifies the Public Access Block configuration for an Amazon
#' Web Services account
#'
#' Creates or modifies the Public Access Block configuration for an Amazon
#' Web Services account.
#'
#' @usage
#' s3control_put_public_access_block(PublicAccessBlockConfiguration,
#'   AccountId)
#'
#' @param PublicAccessBlockConfiguration &#91;required&#93; The Public Access Block configuration that you want to apply to this
#' Amazon Web Services account.
#' @param AccountId &#91;required&#93; The Account ID for the Amazon Web Services account whose Public Access
#' Block configuration you want to set.
#'
#' @section Request syntax:
#' ```
#' svc$put_public_access_block(
#'   PublicAccessBlockConfiguration = list(
#'     BlockPublicAcls = TRUE|FALSE,
#'     IgnorePublicAcls = TRUE|FALSE,
#'     BlockPublicPolicy = TRUE|FALSE,
#'     RestrictPublicBuckets = TRUE|FALSE
#'   ),
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_put_public_access_block
s3control_put_public_access_block <- function(PublicAccessBlockConfiguration, AccountId) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$put_public_access_block_input(PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, AccountId = AccountId)
  output <- .s3control$put_public_access_block_output()
  svc <- .s3control$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_public_access_block <- s3control_put_public_access_block
