% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_replicate_key}
\alias{kms_replicate_key}
\title{Replicates a multi-Region key into the specified Region}
\usage{
kms_replicate_key(
  KeyId,
  ReplicaRegion,
  Policy = NULL,
  BypassPolicyLockoutSafetyCheck = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{KeyId}{[required] Identifies the multi-Region primary key that is being replicated. To
determine whether a KMS key is a multi-Region primary key, use the
\code{\link[=kms_describe_key]{describe_key}} operation to check the value of the
\code{MultiRegionKeyType} property.

Specify the key ID or key ARN of a multi-Region primary key.

For example:
\itemize{
\item Key ID: \verb{mrk-1234abcd12ab34cd56ef1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{ReplicaRegion}{[required] The Region ID of the Amazon Web Services Region for this replica key.

Enter the Region ID, such as \code{us-east-1} or \code{ap-southeast-2}. For a list
of Amazon Web Services Regions in which KMS is supported, see \href{https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region}{KMS service endpoints}
in the \emph{Amazon Web Services General Reference}.

HMAC KMS keys are not supported in all Amazon Web Services Regions. If
you try to replicate an HMAC KMS key in an Amazon Web Services Region in
which HMAC keys are not supported, the
\code{\link[=kms_replicate_key]{replicate_key}} operation returns an
\code{UnsupportedOperationException}. For a list of Regions in which HMAC KMS
keys are supported, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html}{HMAC keys in KMS} in
the \emph{Key Management Service Developer Guide}.

The replica must be in a different Amazon Web Services Region than its
primary key and other replicas of that primary key, but in the same
Amazon Web Services partition. KMS must be available in the replica
Region. If the Region is not enabled by default, the Amazon Web Services
account must be enabled in the Region. For information about Amazon Web
Services partitions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}. For information about
enabling and disabling Regions, see \href{https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-enable}{Enabling a Region}
and \href{https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-disable}{Disabling a Region}
in the \emph{Amazon Web Services General Reference}.}

\item{Policy}{The key policy to attach to the KMS key. This parameter is optional. If
you do not provide a key policy, KMS attaches the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default}{default key policy}
to the KMS key.

The key policy is not a shared property of multi-Region keys. You can
specify the same key policy or a different key policy for each key in a
set of related multi-Region keys. KMS does not synchronize this
property.

If you provide a key policy, it must meet the following criteria:
\itemize{
\item The key policy must allow the calling principal to make a subsequent
\code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS key. This
reduces the risk that the KMS key becomes unmanageable. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key}{Default key policy}
in the \emph{Key Management Service Developer Guide}. (To omit this
condition, set \code{BypassPolicyLockoutSafetyCheck} to true.)
\item Each statement in the key policy must contain one or more
principals. The principals in the key policy must exist and be
visible to KMS. When you create a new Amazon Web Services principal,
you might need to enforce a delay before including the new principal
in a key policy because the new principal might not be immediately
visible to KMS. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot.html#troubleshoot_general_eventual-consistency}{Changes that I make are not always immediately visible}
in the \emph{Amazon Web Services Identity and Access Management User
Guide}.
}

A key policy document can include only the following characters:
\itemize{
\item Printable ASCII characters from the space character (\code{U+0020})
through the end of the ASCII character range.
\item Printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF}).
\item The tab (\code{U+0009}), line feed (\verb{U+000A}), and carriage return
(\verb{U+000D}) special characters
}

For information about key policies, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html}{Key policies in KMS}
in the \emph{Key Management Service Developer Guide}. For help writing and
formatting a JSON policy document, see the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON Policy Reference}
in the \emph{Identity and Access Management User Guide} .}

\item{BypassPolicyLockoutSafetyCheck}{Skips ("bypasses") the key policy lockout safety check. The default
value is false.

Setting this value to true increases the risk that the KMS key becomes
unmanageable. Do not set this value to true indiscriminately.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key}{Default key policy}
in the \emph{Key Management Service Developer Guide}.

Use this parameter only when you intend to prevent the principal that is
making the request from making a subsequent
\code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS key.}

\item{Description}{A description of the KMS key. The default value is an empty string (no
description).

Do not include confidential or sensitive information in this field. This
field may be displayed in plaintext in CloudTrail logs and other output.

The description is not a shared property of multi-Region keys. You can
specify the same description or a different description for each key in
a set of related multi-Region keys. KMS does not synchronize this
property.}

\item{Tags}{Assigns one or more tags to the replica key. Use this parameter to tag
the KMS key when it is created. To tag an existing KMS key, use the
\code{\link[=kms_tag_resource]{tag_resource}} operation.

Do not include confidential or sensitive information in this field. This
field may be displayed in plaintext in CloudTrail logs and other output.

Tagging or untagging a KMS key can allow or deny permission to the KMS
key. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/abac.html}{ABAC for KMS} in
the \emph{Key Management Service Developer Guide}.

To use this parameter, you must have
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:TagResource}
permission in an IAM policy.

Tags are not a shared property of multi-Region keys. You can specify the
same tags or different tags for each key in a set of related
multi-Region keys. KMS does not synchronize this property.

Each tag consists of a tag key and a tag value. Both the tag key and the
tag value are required, but the tag value can be an empty (null) string.
You cannot have more than one tag on a KMS key with the same tag key. If
you specify an existing tag key with a different tag value, KMS replaces
the current tag value with the specified one.

When you add tags to an Amazon Web Services resource, Amazon Web
Services generates a cost allocation report with usage and costs
aggregated by tags. Tags can also be used to control access to a KMS
key. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html}{Tagging Keys}.}
}
\description{
Replicates a multi-Region key into the specified Region. This operation creates a multi-Region replica key based on a multi-Region primary key in a different Region of the same Amazon Web Services partition. You can create multiple replicas of a primary key, but each must be in a different Region. To create a multi-Region primary key, use the \code{\link[=kms_create_key]{create_key}} operation.

See \url{https://www.paws-r-sdk.com/docs/kms_replicate_key/} for full documentation.
}
\keyword{internal}
