% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool_client}
\alias{cognitoidentityprovider_update_user_pool_client}
\title{Updates the specified user pool app client with the specified attributes}
\usage{
cognitoidentityprovider_update_user_pool_client(
  UserPoolId,
  ClientId,
  ClientName = NULL,
  RefreshTokenValidity = NULL,
  AccessTokenValidity = NULL,
  IdTokenValidity = NULL,
  TokenValidityUnits = NULL,
  ReadAttributes = NULL,
  WriteAttributes = NULL,
  ExplicitAuthFlows = NULL,
  SupportedIdentityProviders = NULL,
  CallbackURLs = NULL,
  LogoutURLs = NULL,
  DefaultRedirectURI = NULL,
  AllowedOAuthFlows = NULL,
  AllowedOAuthScopes = NULL,
  AllowedOAuthFlowsUserPoolClient = NULL,
  AnalyticsConfiguration = NULL,
  PreventUserExistenceErrors = NULL,
  EnableTokenRevocation = NULL,
  EnablePropagateAdditionalUserContextData = NULL,
  AuthSessionValidity = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where you want to update the user pool client.}

\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{ClientName}{The client name from the update user pool client request.}

\item{RefreshTokenValidity}{The refresh token time limit. After this limit expires, your user can't
use their refresh token. To specify the time unit for
\code{RefreshTokenValidity} as \code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set
a \code{TokenValidityUnits} value in your API request.

For example, when you set \code{RefreshTokenValidity} as \code{10} and
\code{TokenValidityUnits} as \code{days}, your user can refresh their session and
retrieve new access and ID tokens for 10 days.

The default time unit for \code{RefreshTokenValidity} in an API request is
days. You can't set \code{RefreshTokenValidity} to 0. If you do, Amazon
Cognito overrides the value with the default value of 30 days. \emph{Valid
range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your refresh tokens are valid for 30 days.}

\item{AccessTokenValidity}{The access token time limit. After this limit expires, your user can't
use their access token. To specify the time unit for
\code{AccessTokenValidity} as \code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set a
\code{TokenValidityUnits} value in your API request.

For example, when you set \code{AccessTokenValidity} to \code{10} and
\code{TokenValidityUnits} to \code{hours}, your user can authorize access with
their access token for 10 hours.

The default time unit for \code{AccessTokenValidity} in an API request is
hours. \emph{Valid range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your access tokens are valid for one hour.}

\item{IdTokenValidity}{The ID token time limit. After this limit expires, your user can't use
their ID token. To specify the time unit for \code{IdTokenValidity} as
\code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set a \code{TokenValidityUnits}
value in your API request.

For example, when you set \code{IdTokenValidity} as \code{10} and
\code{TokenValidityUnits} as \code{hours}, your user can authenticate their
session with their ID token for 10 hours.

The default time unit for \code{IdTokenValidity} in an API request is hours.
\emph{Valid range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your ID tokens are valid for one hour.}

\item{TokenValidityUnits}{The time units you use when you set the duration of ID, access, and
refresh tokens. The default unit for RefreshToken is days, and the
default for ID and access tokens is hours.}

\item{ReadAttributes}{The list of user attributes that you want your app client to have read
access to. After your user authenticates in your app, their access token
authorizes them to read their own attribute value for any attribute in
this list. An example of this kind of activity is when your user selects
a link to view their profile information. Your app makes a
\code{\link[=cognitoidentityprovider_get_user]{get_user}} API request to retrieve
and display your user's profile data.

When you don't specify the \code{ReadAttributes} for your app client, your
app can read the values of \code{email_verified}, \code{phone_number_verified},
and the Standard attributes of your user pool. When your user pool app
client has read access to these default attributes, \code{ReadAttributes}
doesn't return any information. Amazon Cognito only populates
\code{ReadAttributes} in the API response if you have specified your own
custom set of read attributes.}

\item{WriteAttributes}{The list of user attributes that you want your app client to have write
access to. After your user authenticates in your app, their access token
authorizes them to set or modify their own attribute value for any
attribute in this list. An example of this kind of activity is when you
present your user with a form to update their profile information and
they change their last name. Your app then makes an
\code{\link[=cognitoidentityprovider_update_user_attributes]{update_user_attributes}}
API request and sets \code{family_name} to the new value.

When you don't specify the \code{WriteAttributes} for your app client, your
app can write the values of the Standard attributes of your user pool.
When your user pool has write access to these default attributes,
\code{WriteAttributes} doesn't return any information. Amazon Cognito only
populates \code{WriteAttributes} in the API response if you have specified
your own custom set of write attributes.

If your app client allows users to sign in through an IdP, this array
must include all attributes that you have mapped to IdP attributes.
Amazon Cognito updates mapped attributes when users sign in to your
application through an IdP. If your app client does not have write
access to a mapped attribute, Amazon Cognito throws an error when it
tries to update the attribute. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html}{Specifying IdP Attribute Mappings for Your user pool}.}

\item{ExplicitAuthFlows}{The authentication flows that you want your user pool client to support.
For each app client in your user pool, you can sign in your users with
any combination of one or more flows, including with a user name and
Secure Remote Password (SRP), a user name and password, or a custom
authentication process that you define with Lambda functions.

If you don't specify a value for \code{ExplicitAuthFlows}, your user client
supports \code{ALLOW_REFRESH_TOKEN_AUTH}, \code{ALLOW_USER_SRP_AUTH}, and
\code{ALLOW_CUSTOM_AUTH}.

Valid values include:
\itemize{
\item \code{ALLOW_USER_AUTH}: Enable selection-based sign-in with \code{USER_AUTH}.
This setting covers username-password, secure remote password (SRP),
passwordless, and passkey authentication. This authentiation flow
can do username-password and SRP authentication without other
\code{ExplicitAuthFlows} permitting them. For example users can complete
an SRP challenge through \code{USER_AUTH} without the flow
\code{USER_SRP_AUTH} being active for the app client. This flow doesn't
include \code{CUSTOM_AUTH}.
\item \code{ALLOW_ADMIN_USER_PASSWORD_AUTH}: Enable admin based user password
authentication flow \code{ADMIN_USER_PASSWORD_AUTH}. This setting
replaces the \code{ADMIN_NO_SRP_AUTH} setting. With this authentication
flow, your app passes a user name and password to Amazon Cognito in
the request, instead of using the Secure Remote Password (SRP)
protocol to securely transmit the password.
\item \code{ALLOW_CUSTOM_AUTH}: Enable Lambda trigger based authentication.
\item \code{ALLOW_USER_PASSWORD_AUTH}: Enable user password-based
authentication. In this flow, Amazon Cognito receives the password
in the request instead of using the SRP protocol to verify
passwords.
\item \code{ALLOW_USER_SRP_AUTH}: Enable SRP-based authentication.
\item \code{ALLOW_REFRESH_TOKEN_AUTH}: Enable authflow to refresh tokens.
}

In some environments, you will see the values \code{ADMIN_NO_SRP_AUTH},
\code{CUSTOM_AUTH_FLOW_ONLY}, or \code{USER_PASSWORD_AUTH}. You can't assign these
legacy \code{ExplicitAuthFlows} values to user pool clients at the same time
as values that begin with \code{ALLOW_}, like \code{ALLOW_USER_SRP_AUTH}.}

\item{SupportedIdentityProviders}{A list of provider names for the identity providers (IdPs) that are
supported on this client. The following are supported: \code{COGNITO},
\code{Facebook}, \code{Google}, \code{SignInWithApple}, and \code{LoginWithAmazon}. You can
also specify the names that you configured for the SAML and OIDC IdPs in
your user pool, for example \code{MySAMLIdP} or \code{MyOIDCIdP}.

This setting applies to providers that you can access with \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html}{managed login}.
The removal of \code{COGNITO} from this list doesn't prevent authentication
operations for local users with the user pools API in an Amazon Web
Services SDK. The only way to prevent API-based authentication is to
block access with a \href{https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html}{WAF rule}.}

\item{CallbackURLs}{A list of allowed redirect (callback) URLs for the IdPs.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as \verb{myapp://example} are also supported.}

\item{LogoutURLs}{A list of allowed logout URLs for the IdPs.}

\item{DefaultRedirectURI}{The default redirect URI. Must be in the \code{CallbackURLs} list.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for \verb{http://localhost}
for testing purposes only.

App callback URLs such as \verb{myapp://example} are also supported.}

\item{AllowedOAuthFlows}{The allowed OAuth flows.

\strong{code}

Use a code grant flow, which provides an authorization code as the
response. This code can be exchanged for access tokens with the
\verb{/oauth2/token} endpoint.

\strong{implicit}

Issue the access token (and, optionally, ID token, based on scopes)
directly to your user.

\strong{client_credentials}

Issue the access token from the \verb{/oauth2/token} endpoint directly to a
non-person user using a combination of the client ID and client secret.}

\item{AllowedOAuthScopes}{The allowed OAuth scopes. Possible values provided by OAuth are \code{phone},
\code{email}, \code{openid}, and \code{profile}. Possible values provided by Amazon Web
Services are \code{aws.cognito.signin.user.admin}. Custom scopes created in
Resource Servers are also supported.}

\item{AllowedOAuthFlowsUserPoolClient}{Set to \code{true} to use OAuth 2.0 features in your user pool app client.

\code{AllowedOAuthFlowsUserPoolClient} must be \code{true} before you can
configure the following features in your app client.
\itemize{
\item \code{CallBackURLs}: Callback URLs.
\item \code{LogoutURLs}: Sign-out redirect URLs.
\item \code{AllowedOAuthScopes}: OAuth 2.0 scopes.
\item \code{AllowedOAuthFlows}: Support for authorization code, implicit, and
client credentials OAuth 2.0 grants.
}

To use OAuth 2.0 features, configure one of these features in the Amazon
Cognito console or set \code{AllowedOAuthFlowsUserPoolClient} to \code{true} in a
\code{\link[=cognitoidentityprovider_create_user_pool_client]{create_user_pool_client}}
or
\code{\link[=cognitoidentityprovider_update_user_pool_client]{update_user_pool_client}}
API request. If you don't set a value for
\code{AllowedOAuthFlowsUserPoolClient} in a request with the CLI or SDKs, it
defaults to \code{false}.}

\item{AnalyticsConfiguration}{The Amazon Pinpoint analytics configuration necessary to collect metrics
for this user pool.

In Amazon Web Services Regions where Amazon Pinpoint isn't available,
user pools only support sending events to Amazon Pinpoint projects in
us-east-1. In Regions where Amazon Pinpoint is available, user pools
support sending events to Amazon Pinpoint projects within that same
Region.}

\item{PreventUserExistenceErrors}{Errors and responses that you want Amazon Cognito APIs to return during
authentication, account confirmation, and password recovery when the
user doesn't exist in the user pool. When set to \code{ENABLED} and the user
doesn't exist, authentication returns an error indicating either the
username or password was incorrect. Account confirmation and password
recovery return a response indicating a code was sent to a simulated
destination. When set to \code{LEGACY}, those APIs return a
\code{UserNotFoundException} exception if the user doesn't exist in the user
pool.

Valid values include:
\itemize{
\item \code{ENABLED} - This prevents user existence-related errors.
\item \code{LEGACY} - This represents the early behavior of Amazon Cognito
where user existence related errors aren't prevented.
}

Defaults to \code{LEGACY} when you don't provide a value.}

\item{EnableTokenRevocation}{Activates or deactivates token revocation. For more information about
revoking tokens, see
\code{\link[=cognitoidentityprovider_revoke_token]{revoke_token}}.}

\item{EnablePropagateAdditionalUserContextData}{Activates the propagation of additional user context data. For more
information about propagation of user context data, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-threat-protection.html}{Adding advanced security to a user pool}.
If you don’t include this parameter, you can't send device fingerprint
information, including source IP address, to Amazon Cognito advanced
security. You can only activate
\code{EnablePropagateAdditionalUserContextData} in an app client that has a
client secret.}

\item{AuthSessionValidity}{Amazon Cognito creates a session token for each API request in an
authentication flow. \code{AuthSessionValidity} is the duration, in minutes,
of that session token. Your user pool native user must respond to each
authentication challenge before the session expires.}
}
\description{
Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using \code{\link[=cognitoidentityprovider_describe_user_pool_client]{describe_user_pool_client}}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool_client/} for full documentation.
}
\keyword{internal}
