% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanroomsml_service.R
\name{cleanroomsml}
\alias{cleanroomsml}
\title{AWS Clean Rooms ML}
\usage{
cleanroomsml(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Welcome to the \emph{Amazon Web Services Clean Rooms ML API Reference}.

Amazon Web Services Clean Rooms ML provides a privacy-enhancing method
for two parties to identify similar users in their data without the need
to share their data with each other. The first party brings the training
data to Clean Rooms so that they can create and configure an audience
model (lookalike model) and associate it with a collaboration. The
second party then brings their seed data to Clean Rooms and generates an
audience (lookalike segment) that resembles the training data.

To learn more about Amazon Web Services Clean Rooms ML concepts,
procedures, and best practices, see the \href{https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html}{Clean Rooms User Guide}.

To learn more about SQL commands, functions, and conditions supported in
Clean Rooms, see the \href{https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html}{Clean Rooms SQL Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- cleanroomsml(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=cleanroomsml_cancel_trained_model]{cancel_trained_model} \tab Submits a request to cancel the trained model job\cr
\link[=cleanroomsml_cancel_trained_model_inference_job]{cancel_trained_model_inference_job} \tab Submits a request to cancel a trained model inference job\cr
\link[=cleanroomsml_create_audience_model]{create_audience_model} \tab Defines the information necessary to create an audience model\cr
\link[=cleanroomsml_create_configured_audience_model]{create_configured_audience_model} \tab Defines the information necessary to create a configured audience model\cr
\link[=cleanroomsml_create_configured_model_algorithm]{create_configured_model_algorithm} \tab Creates a configured model algorithm using a container image stored in an ECR repository\cr
\link[=cleanroomsml_create_configured_model_algorithm_association]{create_configured_model_algorithm_association} \tab Associates a configured model algorithm to a collaboration for use by any member of the collaboration\cr
\link[=cleanroomsml_create_ml_input_channel]{create_ml_input_channel} \tab Provides the information to create an ML input channel\cr
\link[=cleanroomsml_create_trained_model]{create_trained_model} \tab Creates a trained model from an associated configured model algorithm using data from any member of the collaboration\cr
\link[=cleanroomsml_create_training_dataset]{create_training_dataset} \tab Defines the information necessary to create a training dataset\cr
\link[=cleanroomsml_delete_audience_generation_job]{delete_audience_generation_job} \tab Deletes the specified audience generation job, and removes all data associated with the job\cr
\link[=cleanroomsml_delete_audience_model]{delete_audience_model} \tab Specifies an audience model that you want to delete\cr
\link[=cleanroomsml_delete_configured_audience_model]{delete_configured_audience_model} \tab Deletes the specified configured audience model\cr
\link[=cleanroomsml_delete_configured_audience_model_policy]{delete_configured_audience_model_policy} \tab Deletes the specified configured audience model policy\cr
\link[=cleanroomsml_delete_configured_model_algorithm]{delete_configured_model_algorithm} \tab Deletes a configured model algorithm\cr
\link[=cleanroomsml_delete_configured_model_algorithm_association]{delete_configured_model_algorithm_association} \tab Deletes a configured model algorithm association\cr
\link[=cleanroomsml_delete_ml_configuration]{delete_ml_configuration} \tab Deletes a ML modeling configuration\cr
\link[=cleanroomsml_delete_ml_input_channel_data]{delete_ml_input_channel_data} \tab Provides the information necessary to delete an ML input channel\cr
\link[=cleanroomsml_delete_trained_model_output]{delete_trained_model_output} \tab Deletes the output of a trained model\cr
\link[=cleanroomsml_delete_training_dataset]{delete_training_dataset} \tab Specifies a training dataset that you want to delete\cr
\link[=cleanroomsml_get_audience_generation_job]{get_audience_generation_job} \tab Returns information about an audience generation job\cr
\link[=cleanroomsml_get_audience_model]{get_audience_model} \tab Returns information about an audience model\cr
\link[=cleanroomsml_get_collaboration_configured_model_algorithm_association]{get_collaboration_configured_model_algorithm_association} \tab Returns information about the configured model algorithm association in a collaboration\cr
\link[=cleanroomsml_get_collaboration_ml_input_channel]{get_collaboration_ml_input_channel} \tab Returns information about a specific ML input channel in a collaboration\cr
\link[=cleanroomsml_get_collaboration_trained_model]{get_collaboration_trained_model} \tab Returns information about a trained model in a collaboration\cr
\link[=cleanroomsml_get_configured_audience_model]{get_configured_audience_model} \tab Returns information about a specified configured audience model\cr
\link[=cleanroomsml_get_configured_audience_model_policy]{get_configured_audience_model_policy} \tab Returns information about a configured audience model policy\cr
\link[=cleanroomsml_get_configured_model_algorithm]{get_configured_model_algorithm} \tab Returns information about a configured model algorithm\cr
\link[=cleanroomsml_get_configured_model_algorithm_association]{get_configured_model_algorithm_association} \tab Returns information about a configured model algorithm association\cr
\link[=cleanroomsml_get_ml_configuration]{get_ml_configuration} \tab Returns information about a specific ML configuration\cr
\link[=cleanroomsml_get_ml_input_channel]{get_ml_input_channel} \tab Returns information about an ML input channel\cr
\link[=cleanroomsml_get_trained_model]{get_trained_model} \tab Returns information about a trained model\cr
\link[=cleanroomsml_get_trained_model_inference_job]{get_trained_model_inference_job} \tab Returns information about a trained model inference job\cr
\link[=cleanroomsml_get_training_dataset]{get_training_dataset} \tab Returns information about a training dataset\cr
\link[=cleanroomsml_list_audience_export_jobs]{list_audience_export_jobs} \tab Returns a list of the audience export jobs\cr
\link[=cleanroomsml_list_audience_generation_jobs]{list_audience_generation_jobs} \tab Returns a list of audience generation jobs\cr
\link[=cleanroomsml_list_audience_models]{list_audience_models} \tab Returns a list of audience models\cr
\link[=cleanroomsml_list_collaboration_configured_model_algorithm_associations]{list_collaboration_configured_model_algorithm_associations} \tab Returns a list of the configured model algorithm associations in a collaboration\cr
\link[=cleanroomsml_list_collaboration_ml_input_channels]{list_collaboration_ml_input_channels} \tab Returns a list of the ML input channels in a collaboration\cr
\link[=cleanroomsml_list_collaboration_trained_model_export_jobs]{list_collaboration_trained_model_export_jobs} \tab Returns a list of the export jobs for a trained model in a collaboration\cr
\link[=cleanroomsml_list_collaboration_trained_model_inference_jobs]{list_collaboration_trained_model_inference_jobs} \tab Returns a list of trained model inference jobs in a specified collaboration\cr
\link[=cleanroomsml_list_collaboration_trained_models]{list_collaboration_trained_models} \tab Returns a list of the trained models in a collaboration\cr
\link[=cleanroomsml_list_configured_audience_models]{list_configured_audience_models} \tab Returns a list of the configured audience models\cr
\link[=cleanroomsml_list_configured_model_algorithm_associations]{list_configured_model_algorithm_associations} \tab Returns a list of configured model algorithm associations\cr
\link[=cleanroomsml_list_configured_model_algorithms]{list_configured_model_algorithms} \tab Returns a list of configured model algorithms\cr
\link[=cleanroomsml_list_ml_input_channels]{list_ml_input_channels} \tab Returns a list of ML input channels\cr
\link[=cleanroomsml_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags for a provided resource\cr
\link[=cleanroomsml_list_trained_model_inference_jobs]{list_trained_model_inference_jobs} \tab Returns a list of trained model inference jobs that match the request parameters\cr
\link[=cleanroomsml_list_trained_models]{list_trained_models} \tab Returns a list of trained models\cr
\link[=cleanroomsml_list_training_datasets]{list_training_datasets} \tab Returns a list of training datasets\cr
\link[=cleanroomsml_put_configured_audience_model_policy]{put_configured_audience_model_policy} \tab Create or update the resource policy for a configured audience model\cr
\link[=cleanroomsml_put_ml_configuration]{put_ml_configuration} \tab Assigns information about an ML configuration\cr
\link[=cleanroomsml_start_audience_export_job]{start_audience_export_job} \tab Export an audience of a specified size after you have generated an audience\cr
\link[=cleanroomsml_start_audience_generation_job]{start_audience_generation_job} \tab Information necessary to start the audience generation job\cr
\link[=cleanroomsml_start_trained_model_export_job]{start_trained_model_export_job} \tab Provides the information necessary to start a trained model export job\cr
\link[=cleanroomsml_start_trained_model_inference_job]{start_trained_model_inference_job} \tab Defines the information necessary to begin a trained model inference job\cr
\link[=cleanroomsml_tag_resource]{tag_resource} \tab Adds metadata tags to a specified resource\cr
\link[=cleanroomsml_untag_resource]{untag_resource} \tab Removes metadata tags from a specified resource\cr
\link[=cleanroomsml_update_configured_audience_model]{update_configured_audience_model} \tab Provides the information necessary to update a configured audience model
}
}

\examples{
\dontrun{
svc <- cleanroomsml()
svc$cancel_trained_model(
  Foo = 123
)
}

}
