% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_update_identity_source}
\alias{verifiedpermissions_update_identity_source}
\title{Updates the specified identity source to use a new identity provider
(IdP) source, or to change the mapping of identities from the IdP to a
different principal entity type}
\usage{
verifiedpermissions_update_identity_source(
  policyStoreId,
  identitySourceId,
  updateConfiguration,
  principalEntityType = NULL
)
}
\arguments{
\item{policyStoreId}{[required] Specifies the ID of the policy store that contains the identity source
that you want to update.}

\item{identitySourceId}{[required] Specifies the ID of the identity source that you want to update.}

\item{updateConfiguration}{[required] Specifies the details required to communicate with the identity provider
(IdP) associated with this identity source.

At this time, the only valid member of this structure is a Amazon
Cognito user pool configuration.

You must specify a \code{userPoolArn}, and optionally, a \code{ClientId}.}

\item{principalEntityType}{Specifies the data type of principals generated for identities
authenticated by the identity source.}
}
\description{
Updates the specified identity source to use a new identity provider (IdP) source, or to change the mapping of identities from the IdP to a different principal entity type.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_update_identity_source/} for full documentation.
}
\keyword{internal}
