# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Shield
#'
#' @description
#' Shield Advanced
#' 
#' This is the *Shield Advanced API Reference*. This guide is for
#' developers who need detailed information about the Shield Advanced API
#' actions, data types, and errors. For detailed information about WAF and
#' Shield Advanced features and an overview of how to use the WAF and
#' Shield Advanced APIs, see the [WAF and Shield Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- shield(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- shield()
#' svc$associate_drt_log_bucket(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=shield_associate_drt_log_bucket]{associate_drt_log_bucket} \tab Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources\cr
#'  \link[=shield_associate_drt_role]{associate_drt_role} \tab Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks\cr
#'  \link[=shield_associate_health_check]{associate_health_check} \tab Adds health-based detection to the Shield Advanced protection for a resource\cr
#'  \link[=shield_associate_proactive_engagement_details]{associate_proactive_engagement_details} \tab Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use\cr
#'  \link[=shield_create_protection]{create_protection} \tab Enables Shield Advanced for a specific Amazon Web Services resource\cr
#'  \link[=shield_create_protection_group]{create_protection_group} \tab Creates a grouping of protected resources so they can be handled as a collective\cr
#'  \link[=shield_create_subscription]{create_subscription} \tab Activates Shield Advanced for an account\cr
#'  \link[=shield_delete_protection]{delete_protection} \tab Deletes an Shield Advanced Protection\cr
#'  \link[=shield_delete_protection_group]{delete_protection_group} \tab Removes the specified protection group\cr
#'  \link[=shield_delete_subscription]{delete_subscription} \tab Removes Shield Advanced from an account\cr
#'  \link[=shield_describe_attack]{describe_attack} \tab Describes the details of a DDoS attack\cr
#'  \link[=shield_describe_attack_statistics]{describe_attack_statistics} \tab Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them\cr
#'  \link[=shield_describe_drt_access]{describe_drt_access} \tab Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation\cr
#'  \link[=shield_describe_emergency_contact_settings]{describe_emergency_contact_settings} \tab A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support\cr
#'  \link[=shield_describe_protection]{describe_protection} \tab Lists the details of a Protection object\cr
#'  \link[=shield_describe_protection_group]{describe_protection_group} \tab Returns the specification for the specified protection group\cr
#'  \link[=shield_describe_subscription]{describe_subscription} \tab Provides details about the Shield Advanced subscription for an account\cr
#'  \link[=shield_disable_application_layer_automatic_response]{disable_application_layer_automatic_response} \tab Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource\cr
#'  \link[=shield_disable_proactive_engagement]{disable_proactive_engagement} \tab Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support\cr
#'  \link[=shield_disassociate_drt_log_bucket]{disassociate_drt_log_bucket} \tab Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously\cr
#'  \link[=shield_disassociate_drt_role]{disassociate_drt_role} \tab Removes the Shield Response Team's (SRT) access to your Amazon Web Services account\cr
#'  \link[=shield_disassociate_health_check]{disassociate_health_check} \tab Removes health-based detection from the Shield Advanced protection for a resource\cr
#'  \link[=shield_enable_application_layer_automatic_response]{enable_application_layer_automatic_response} \tab Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource\cr
#'  \link[=shield_enable_proactive_engagement]{enable_proactive_engagement} \tab Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support\cr
#'  \link[=shield_get_subscription_state]{get_subscription_state} \tab Returns the SubscriptionState, either Active or Inactive\cr
#'  \link[=shield_list_attacks]{list_attacks} \tab Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period\cr
#'  \link[=shield_list_protection_groups]{list_protection_groups} \tab Retrieves ProtectionGroup objects for the account\cr
#'  \link[=shield_list_protections]{list_protections} \tab Retrieves Protection objects for the account\cr
#'  \link[=shield_list_resources_in_protection_group]{list_resources_in_protection_group} \tab Retrieves the resources that are included in the protection group\cr
#'  \link[=shield_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield\cr
#'  \link[=shield_tag_resource]{tag_resource} \tab Adds or updates tags for a resource in Shield\cr
#'  \link[=shield_untag_resource]{untag_resource} \tab Removes tags from a resource in Shield\cr
#'  \link[=shield_update_application_layer_automatic_response]{update_application_layer_automatic_response} \tab Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified resource\cr
#'  \link[=shield_update_emergency_contact_settings]{update_emergency_contact_settings} \tab Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support\cr
#'  \link[=shield_update_protection_group]{update_protection_group} \tab Updates an existing protection group\cr
#'  \link[=shield_update_subscription]{update_subscription} \tab Updates the details of an existing subscription
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname shield
#' @export
shield <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .shield$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.shield <- list()

.shield$operations <- list()

.shield$metadata <- list(
  service_name = "shield",
  endpoints = list("*" = list(endpoint = "shield.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "shield.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "shield.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "shield.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "shield.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "shield.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Shield",
  api_version = "2016-06-02",
  signing_name = "shield",
  json_version = "1.1",
  target_prefix = "AWSShield_20160616"
)

.shield$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.shield$metadata, handlers, config)
}
