% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_put_resource_policy}
\alias{secretsmanager_put_resource_policy}
\title{Attaches a resource-based permission policy to a secret}
\usage{
secretsmanager_put_resource_policy(
  SecretId,
  ResourcePolicy,
  BlockPublicPolicy = NULL
)
}
\arguments{
\item{SecretId}{[required] The ARN or name of the secret to attach the resource-based policy.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{ResourcePolicy}{[required] A JSON-formatted string for an Amazon Web Services resource-based
policy. For example policies, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html}{Permissions policy examples}.}

\item{BlockPublicPolicy}{Specifies whether to block resource-based policies that allow broad
access to the secret, for example those that use a wildcard for the
principal. By default, public policies aren't blocked.}
}
\description{
Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more information, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html}{Authentication and access control for Secrets Manager}

See \url{https://www.paws-r-sdk.com/docs/secretsmanager_put_resource_policy/} for full documentation.
}
\keyword{internal}
