% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_regex_match_set}
\alias{wafregional_create_regex_match_set}
\title{Creates a RegexMatchSet}
\usage{
wafregional_create_regex_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the RegexMatchSet. You can't change
\code{Name} after you create a \code{RegexMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates a RegexMatchSet. You then use UpdateRegexMatchSet to identify
the part of a web request that you want AWS WAF to inspect, such as the
values of the \code{User-Agent} header or the query string. For example, you
can create a \code{RegexMatchSet} that contains a \code{RegexMatchTuple} that
looks for any requests with \code{User-Agent} headers that match a
\code{RegexPatternSet} with pattern \code{B\\[a@\\]dB\\[o0\\]t}. You can then
configure AWS WAF to reject those requests.
}
\details{
To create and configure a \code{RegexMatchSet}, perform the following steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateRegexMatchSet} request.
\item Submit a \code{CreateRegexMatchSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an \code{UpdateRegexMatchSet} request.
\item Submit an UpdateRegexMatchSet request to specify the part of the
request that you want AWS WAF to inspect (for example, the header or
the URI) and the value, using a \code{RegexPatternSet}, that you want AWS
WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_regex_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
