% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_stop_user_import_job}
\alias{cognitoidentityprovider_stop_user_import_job}
\title{Stops the user import job}
\usage{
cognitoidentityprovider_stop_user_import_job(UserPoolId, JobId)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool that the users are being imported
into.}

\item{JobId}{[required] The job ID for the user import job.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserImportJob = list(
    JobName = "string",
    JobId = "string",
    UserPoolId = "string",
    PreSignedUrl = "string",
    CreationDate = as.POSIXct(
      "2015-01-01"
    ),
    StartDate = as.POSIXct(
      "2015-01-01"
    ),
    CompletionDate = as.POSIXct(
      "2015-01-01"
    ),
    Status = "Created"|"Pending"|"InProgress"|"Stopping"|"Expired"|"Stopped"|"Failed"|"Succeeded",
    CloudWatchLogsRoleArn = "string",
    ImportedUsers = 123,
    SkippedUsers = 123,
    FailedUsers = 123,
    CompletionMessage = "string"
  )
)
}
}
\description{
Stops the user import job.
}
\section{Request syntax}{
\preformatted{svc$stop_user_import_job(
  UserPoolId = "string",
  JobId = "string"
)
}
}

\keyword{internal}
