% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_size_constraint_set}
\alias{wafregional_create_size_constraint_set}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_create_size_constraint_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the SizeConstraintSet. You can't
change \code{Name} after you create a \code{SizeConstraintSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=wafregional_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  SizeConstraintSet = list(
    SizeConstraintSetId = "string",
    Name = "string",
    SizeConstraints = list(
      list(
        FieldToMatch = list(
          Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
          Data = "string"
        ),
        TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
        ComparisonOperator = "EQ"|"NE"|"LE"|"LT"|"GE"|"GT",
        Size = 123
      )
    )
  ),
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Creates a \code{SizeConstraintSet}. You then use
\code{\link[=wafregional_update_size_constraint_set]{update_size_constraint_set}}
to identify the part of a web request that you want AWS WAF to check for
length, such as the length of the \code{User-Agent} header or the length of
the query string. For example, you can create a \code{SizeConstraintSet} that
matches any requests that have a query string that is longer than 100
bytes. You can then configure AWS WAF to reject those requests.

To create and configure a \code{SizeConstraintSet}, perform the following
steps:
\enumerate{
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=wafregional_create_size_constraint_set]{create_size_constraint_set}}
request.
\item Submit a
\code{\link[=wafregional_create_size_constraint_set]{create_size_constraint_set}}
request.
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of an
\code{\link[=wafregional_update_size_constraint_set]{update_size_constraint_set}}
request.
\item Submit an
\code{\link[=wafregional_update_size_constraint_set]{update_size_constraint_set}}
request to specify the part of the request that you want AWS WAF to
inspect (for example, the header or the URI) and the value that you
want AWS WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_size_constraint_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example creates size constraint set named
# MySampleSizeConstraintSet.
svc$create_size_constraint_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MySampleSizeConstraintSet"
)
}

}
\keyword{internal}
