% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_start_monitoring_members}
\alias{guardduty_start_monitoring_members}
\title{Turns on GuardDuty monitoring of the specified member accounts}
\usage{
guardduty_start_monitoring_members(DetectorId, AccountIds)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty administrator account
associated with the member accounts to monitor.}

\item{AccountIds}{[required] A list of account IDs of the GuardDuty member accounts to start
monitoring.}
}
\value{
A list with the following syntax:\preformatted{list(
  UnprocessedAccounts = list(
    list(
      AccountId = "string",
      Result = "string"
    )
  )
)
}
}
\description{
Turns on GuardDuty monitoring of the specified member accounts. Use this
operation to restart monitoring of accounts that you stopped monitoring
with the \code{\link[=guardduty_stop_monitoring_members]{stop_monitoring_members}}
operation.
}
\section{Request syntax}{
\preformatted{svc$start_monitoring_members(
  DetectorId = "string",
  AccountIds = list(
    "string"
  )
)
}
}

\keyword{internal}
