% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_describe_assessment_targets}
\alias{inspector_describe_assessment_targets}
\title{Describes the assessment targets that are specified by the ARNs of the
assessment targets}
\usage{
inspector_describe_assessment_targets(assessmentTargetArns)
}
\arguments{
\item{assessmentTargetArns}{[required] The ARNs that specifies the assessment targets that you want to
describe.}
}
\description{
Describes the assessment targets that are specified by the ARNs of the
assessment targets.
}
\section{Request syntax}{
\preformatted{svc$describe_assessment_targets(
  assessmentTargetArns = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Describes the assessment targets that are specified by the ARNs of the
# assessment targets.
svc$describe_assessment_targets(
  assessmentTargetArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
  )
)
}

}
\keyword{internal}
