% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_get_network_routes}
\alias{networkmanager_get_network_routes}
\title{Gets the network routes of the specified global network}
\usage{
networkmanager_get_network_routes(
  GlobalNetworkId,
  RouteTableIdentifier,
  ExactCidrMatches = NULL,
  LongestPrefixMatches = NULL,
  SubnetOfMatches = NULL,
  SupernetOfMatches = NULL,
  PrefixListIds = NULL,
  States = NULL,
  Types = NULL,
  DestinationFilters = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{RouteTableIdentifier}{[required] The ID of the route table.}

\item{ExactCidrMatches}{An exact CIDR block.}

\item{LongestPrefixMatches}{The most specific route that matches the traffic (longest prefix match).}

\item{SubnetOfMatches}{The routes with a subnet that match the specified CIDR filter.}

\item{SupernetOfMatches}{The routes with a CIDR that encompasses the CIDR filter. Example: If you
specify 10.0.1.0/30, then the result returns 10.0.1.0/29.}

\item{PrefixListIds}{The IDs of the prefix lists.}

\item{States}{The route states.}

\item{Types}{The route types.}

\item{DestinationFilters}{Filter by route table destination. Possible Values:
TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.}
}
\description{
Gets the network routes of the specified global network.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_get_network_routes/} for full documentation.
}
\keyword{internal}
