% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_endpoints}
\alias{route53resolver_list_resolver_endpoints}
\title{Lists all the Resolver endpoints that were created using the current
Amazon Web Services account}
\usage{
route53resolver_list_resolver_endpoints(
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of Resolver endpoints that you want to return in the
response to a
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request. If you don't specify a value for \code{MaxResults}, Resolver returns
up to 100 Resolver endpoints.}

\item{NextToken}{For the first
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request, omit this value.

If you have more than \code{MaxResults} Resolver endpoints, you can submit
another
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request to get the next group of Resolver endpoints. In the next
request, specify the value of \code{NextToken} from the previous response.}

\item{Filters}{An optional specification to return a subset of Resolver endpoints, such
as all inbound Resolver endpoints.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request and specify the \code{NextToken} parameter, you must use the same
values for \code{Filters}, if any, as in the previous request.}
}
\description{
Lists all the Resolver endpoints that were created using the current Amazon Web Services account.

See \url{https://paws-r.github.io/docs/route53resolver/list_resolver_endpoints.html} for full documentation.
}
\keyword{internal}
