% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_service.R
\name{elbv2}
\alias{elbv2}
\title{Elastic Load Balancing}
\usage{
elbv2(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
A load balancer distributes incoming traffic across targets, such as
your EC2 instances. This enables you to increase the availability of
your application. The load balancer also monitors the health of its
registered targets and ensures that it routes traffic only to healthy
targets. You configure your load balancer to accept incoming traffic by
specifying one or more listeners, which are configured with a protocol
and port number for connections from clients to the load balancer. You
configure a target group with a protocol and port number for connections
from the load balancer to the targets, and with health check settings to
be used when checking the health status of the targets.

Elastic Load Balancing supports the following types of load balancers:
Application Load Balancers, Network Load Balancers, and Classic Load
Balancers. This reference covers Application Load Balancers and Network
Load Balancers.

An Application Load Balancer makes routing and load balancing decisions
at the application layer (HTTP/HTTPS). A Network Load Balancer makes
routing and load balancing decisions at the transport layer (TCP/TLS).
Both Application Load Balancers and Network Load Balancers can route
requests to one or more ports on each EC2 instance or container instance
in your virtual private cloud (VPC). For more information, see the
\href{https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/}{Elastic Load Balancing User Guide}.

All Elastic Load Balancing operations are idempotent, which means that
they complete at most one time. If you repeat an operation, it succeeds.
}
\section{Service syntax}{
\preformatted{svc <- elbv2(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=elbv2_add_listener_certificates]{add_listener_certificates} \tab Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener \cr
\link[=elbv2_add_tags]{add_tags} \tab Adds the specified tags to the specified Elastic Load Balancing resource \cr
\link[=elbv2_create_listener]{create_listener} \tab Creates a listener for the specified Application Load Balancer or Network Load Balancer \cr
\link[=elbv2_create_load_balancer]{create_load_balancer} \tab Creates an Application Load Balancer or a Network Load Balancer \cr
\link[=elbv2_create_rule]{create_rule} \tab Creates a rule for the specified listener \cr
\link[=elbv2_create_target_group]{create_target_group} \tab Creates a target group \cr
\link[=elbv2_delete_listener]{delete_listener} \tab Deletes the specified listener \cr
\link[=elbv2_delete_load_balancer]{delete_load_balancer} \tab Deletes the specified Application Load Balancer or Network Load Balancer and its attached listeners \cr
\link[=elbv2_delete_rule]{delete_rule} \tab Deletes the specified rule \cr
\link[=elbv2_delete_target_group]{delete_target_group} \tab Deletes the specified target group \cr
\link[=elbv2_deregister_targets]{deregister_targets} \tab Deregisters the specified targets from the specified target group \cr
\link[=elbv2_describe_account_limits]{describe_account_limits} \tab Describes the current Elastic Load Balancing resource limits for your AWS account \cr
\link[=elbv2_describe_listener_certificates]{describe_listener_certificates} \tab Describes the default certificate and the certificate list for the specified HTTPS or TLS listener \cr
\link[=elbv2_describe_listeners]{describe_listeners} \tab Describes the specified listeners or the listeners for the specified Application Load Balancer or Network Load Balancer\cr
\link[=elbv2_describe_load_balancer_attributes]{describe_load_balancer_attributes} \tab Describes the attributes for the specified Application Load Balancer or Network Load Balancer \cr
\link[=elbv2_describe_load_balancers]{describe_load_balancers} \tab Describes the specified load balancers or all of your load balancers \cr
\link[=elbv2_describe_rules]{describe_rules} \tab Describes the specified rules or the rules for the specified listener \cr
\link[=elbv2_describe_ssl_policies]{describe_ssl_policies} \tab Describes the specified policies or all policies used for SSL negotiation \cr
\link[=elbv2_describe_tags]{describe_tags} \tab Describes the tags for the specified resources \cr
\link[=elbv2_describe_target_group_attributes]{describe_target_group_attributes} \tab Describes the attributes for the specified target group \cr
\link[=elbv2_describe_target_groups]{describe_target_groups} \tab Describes the specified target groups or all of your target groups \cr
\link[=elbv2_describe_target_health]{describe_target_health} \tab Describes the health of the specified targets or all of your targets \cr
\link[=elbv2_modify_listener]{modify_listener} \tab Replaces the specified properties of the specified listener \cr
\link[=elbv2_modify_load_balancer_attributes]{modify_load_balancer_attributes} \tab Modifies the specified attributes of the specified Application Load Balancer or Network Load Balancer \cr
\link[=elbv2_modify_rule]{modify_rule} \tab Replaces the specified properties of the specified rule \cr
\link[=elbv2_modify_target_group]{modify_target_group} \tab Modifies the health checks used when evaluating the health state of the targets in the specified target group \cr
\link[=elbv2_modify_target_group_attributes]{modify_target_group_attributes} \tab Modifies the specified attributes of the specified target group \cr
\link[=elbv2_register_targets]{register_targets} \tab Registers the specified targets with the specified target group \cr
\link[=elbv2_remove_listener_certificates]{remove_listener_certificates} \tab Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener \cr
\link[=elbv2_remove_tags]{remove_tags} \tab Removes the specified tags from the specified Elastic Load Balancing resource \cr
\link[=elbv2_set_ip_address_type]{set_ip_address_type} \tab Sets the type of IP addresses used by the subnets of the specified Application Load Balancer or Network Load Balancer \cr
\link[=elbv2_set_rule_priorities]{set_rule_priorities} \tab Sets the priorities of the specified rules \cr
\link[=elbv2_set_security_groups]{set_security_groups} \tab Associates the specified security groups with the specified Application Load Balancer \cr
\link[=elbv2_set_subnets]{set_subnets} \tab Enables the Availability Zones for the specified public subnets for the specified load balancer
}
}

\examples{
\dontrun{
svc <- elbv2()
# This example adds the specified tags to the specified load balancer.
svc$add_tags(
  ResourceArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/5..."
  ),
  Tags = list(
    list(
      Key = "project",
      Value = "lima"
    ),
    list(
      Key = "department",
      Value = "digital-media"
    )
  )
)
}

}
