% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_disable_availability_zones_for_load_balancer}
\alias{elb_disable_availability_zones_for_load_balancer}
\title{Removes the specified Availability Zones from the set of Availability
Zones for the specified load balancer in EC2-Classic or a default VPC}
\usage{
elb_disable_availability_zones_for_load_balancer(LoadBalancerName,
  AvailabilityZones)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{AvailabilityZones}{[required] The Availability Zones.}
}
\value{
A list with the following syntax:\preformatted{list(
  AvailabilityZones = list(
    "string"
  )
)
}
}
\description{
Removes the specified Availability Zones from the set of Availability
Zones for the specified load balancer in EC2-Classic or a default VPC.

For load balancers in a non-default VPC, use
\code{\link[=elb_detach_load_balancer_from_subnets]{detach_load_balancer_from_subnets}}.

There must be at least one Availability Zone registered with a load
balancer at all times. After an Availability Zone is removed, all
instances registered with the load balancer that are in the removed
Availability Zone go into the \code{OutOfService} state. Then, the load
balancer attempts to equally balance the traffic among its remaining
Availability Zones.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html}{Add or Remove Availability Zones}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$disable_availability_zones_for_load_balancer(
  LoadBalancerName = "string",
  AvailabilityZones = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example removes the specified Availability Zone from the set of
# Availability Zones for the specified load balancer.
svc$disable_availability_zones_for_load_balancer(
  AvailabilityZones = list(
    "us-west-2a"
  ),
  LoadBalancerName = "my-load-balancer"
)
}

}
\keyword{internal}
